package com.dtyunxi.yundt.cube.center.user.api.dto.ext.user;

/**
 * 用户唯一性校验dto
 * @author : 萧玄
 * @Date: 14:20 2020/1/10
 */
public class UserUniqueCheckDto {

    /**
     * 租户id
     */
    Long tenantId;

    /**
     * 实例id
     */
    Long instanceId;

    /**
     * 用户id
     */
    Long userId;

    /**
     * 校验字段
     */
    String column;

    /**
     * 校验字段值
     */
    Object value;

    /**
     * 是否需要处理租户隔离性
     */
    boolean tenantIsolation;

    /**
     * 用户域
     */
    String domain;

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getColumn() {
        return column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean isTenantIsolation() {
        return tenantIsolation;
    }

    public void setTenantIsolation(boolean tenantIsolation) {
        this.tenantIsolation = tenantIsolation;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    /**
     * 初始化一个不需要租户隔离性处理的的对象实例
     * @author : 萧玄
     * @Date: 14:39 2020/1/10
     */
    public static UserUniqueCheckDto initWithoutTenantIsolation(Long tenantId, Long instanceId, Long userId,String column, Object value) {
        UserUniqueCheckDto userUniqueCheckDto = new UserUniqueCheckDto();
        userUniqueCheckDto.tenantId = tenantId;
        userUniqueCheckDto.instanceId = instanceId;
        userUniqueCheckDto.userId = userId;
        userUniqueCheckDto.column = column;
        userUniqueCheckDto.value = value;
        return userUniqueCheckDto;
    }

    public static UserUniqueCheckDto initDomainAndWithoutTenantIsolation(Long tenantId, Long instanceId, Long userId,String column, Object value, String domain) {
        UserUniqueCheckDto userUniqueCheckDto = new UserUniqueCheckDto();
        userUniqueCheckDto.tenantId = tenantId;
        userUniqueCheckDto.instanceId = instanceId;
        userUniqueCheckDto.userId = userId;
        userUniqueCheckDto.column = column;
        userUniqueCheckDto.value = value;
        userUniqueCheckDto.domain = domain;
        return userUniqueCheckDto;
    }

    /**
     * 初始化一个需要对租户隔离处理的参数实例
     * @author : 萧玄
     * @Date: 14:54 2020/1/10
     */
    public static UserUniqueCheckDto init(Long tenantId, Long instanceId, Long userId,String column, Object value) {
        UserUniqueCheckDto userUniqueCheckDto = new UserUniqueCheckDto();
        userUniqueCheckDto.tenantId = tenantId;
        userUniqueCheckDto.instanceId = instanceId;
        userUniqueCheckDto.userId = userId;
        userUniqueCheckDto.column = column;
        userUniqueCheckDto.value = value;
        userUniqueCheckDto.tenantIsolation = true;
        return userUniqueCheckDto;
    }
}
