/**
 * @(#) UserAddressReqDto.java 1.0 2020-02-20
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;

/**
 * 地址查询Dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
public class AddressQueryReqDto extends BaseDto {

    /**
     * 联系人
     */
    @ApiModelProperty(value = "联系人，选填")
    private String contact;

    /**
     * 联系方式
     */
    @ApiModelProperty(value = "联系方式，选填")
    private String phone;

    /**
     * 所在地区
     */
    @ApiModelProperty(value = "所在地区，选填")
    private String region;

    /**
     * 详细地址
     */
    @ApiModelProperty(value = "详细地址，选填")
    private String detailAddr;

    /**
     * 邮编
     */
    @ApiModelProperty(value = "邮编，选填")
    private String postcode;

    /**
     * 省编号
     */
    @ApiModelProperty(value = "省编号，选填")
    private String provinceCode;

    /**
     * 市编号
     */
    @ApiModelProperty(value = "市编号，选填")
    private String cityCode;

    /**
     * 区编号
     */
    @ApiModelProperty(value = "区编号，选填")
    private String districtCode;

    /**
     * 街道编号
     */
    @ApiModelProperty(value = "街道编号，选填")
    private String streetCode;


    /**
     * 所在省名称
     */
    @ApiModelProperty(value = "所在省名称，选填")
    private String province;

    /**
     * 所在市名称
     */
    @ApiModelProperty(value = "所在市名称，选填")
    private String city;

    /**
     * 所在区名称
     */
    @ApiModelProperty(value = "所在区名称，选填")
    private String district;

    /**
     * 地址类型， 如常用地址, 收货地址, 户籍地址等
     */
    @ApiModelProperty(value = "地址类型,如常用地址, 收货地址, 户籍地址等，选填")
    private String addressType;

    /**
     * 是否默认地址
     * 0 否  1 是
     */
    @ApiModelProperty(value = "是否默认地址: 0 否  1 是，选填")
    private Integer status;

    /**
     * 用户Id
     */
    @ApiModelProperty(value = "用户Id")
    private Long userId;

    /**
     * 非常规查询字段 该字段等于true时 代表 detail_addr is not null
     */
    private Boolean hasDetail;

    public Boolean getHasDetail() {
        return hasDetail;
    }

    public void setHasDetail(Boolean hasDetail) {
        this.hasDetail = hasDetail;
    }

    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getDetailAddr() {
        return detailAddr;
    }

    public void setDetailAddr(String detailAddr) {
        this.detailAddr = detailAddr;
    }

    public String getPostcode() {
        return postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getDistrictCode() {
        return districtCode;
    }

    public void setDistrictCode(String districtCode) {
        this.districtCode = districtCode;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getAddressType() {
        return addressType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }
}
