package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 资源导入请求dto
 *
 * @author 代码生成器
 */
@ApiModel(value = "ResourceImportReqDto", description = "资源导入请求dto")
public class ResourceImportReqDto extends RequestDto {

    /**
     * 编码
     */
    @NotNull(message = "编码不能为空")
    @ApiModelProperty(value = "编码")
    private String code;

    /**
     * 类型:1菜单,2按钮
     */
    @NotNull(message = "类型只能为1菜单或2按钮")
    @ApiModelProperty(value = "类型:1菜单,2按钮")
    private Integer type;

    /**
     * 名称
     */
    @NotNull(message = "名称不能为空")
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 图标
     */
    @ApiModelProperty(value = "图标")
    private String icon;

    /**
     * 用户ID
     */
    @ApiModelProperty(value = "用户ID")
    private Long userId;

    /**
     * 个人ID
     */
    @ApiModelProperty(value = "个人ID")
    private Long personId;

    /**
     * 事件
     */
    @ApiModelProperty(value = "事件")
    private String action;

    /**
     * 父级编码,如果是按钮,此值应用所属的菜单编码
     */
    @NotNull(message = "父级编码不能为空")
    @ApiModelProperty(value = "父级编码,如果是按钮,此值应为所属的菜单编码")
    private String parentCode;

    /**
     * 跳转路径
     */
    @ApiModelProperty(value = "跳转路径")
    private String routePath;

    /**
     * 页面ID
     */
    @ApiModelProperty(value = "页面ID")
    private String pageId;

    /**
     * 序号
     */
    @ApiModelProperty(value = "序号")
    private Integer sortNo;

    /**
     * 状态
     */
    @NotNull(message = "状态不能为空")
    @ApiModelProperty(value = "状态: 1启用 2禁用")
    private Integer status;

    /**
     * 错误信息
     */
    @ApiModelProperty(value = "错误信息")
    private StringBuilder errorMsg = new StringBuilder();

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getPersonId() {
        return this.personId;
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getParentCode() {
        return this.parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getRoutePath() {
        return this.routePath;
    }

    public void setRoutePath(String routePath) {
        this.routePath = routePath;
    }

    public String getPageId() {
        return pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public Integer getSortNo() {
        return this.sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public StringBuilder getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(StringBuilder errorMsg) {
        this.errorMsg = errorMsg;
    }
}