package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.AccessDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import java.util.Set;

/**
 * 编辑角色dto
 *
 * @author 凌澌
 * @date 2021-07-27
 * @since 1.0.0
 */
@ApiModel(value = "RoleAccessModifyReqDto", description = "编辑角色dto")
public class RoleAccessModifyReqDto extends BaseVo {
    /**
     * 角色编号
     */
    @ApiModelProperty("角色编号")
    private String code;

    /**
     * 角色名称
     */
    @ApiModelProperty("角色名称，必填")
    @NotBlank
    private String name;

    /**
     * 状态：1启用2禁用
     */
    @ApiModelProperty(name = "状态：1启用2禁用，默认1启用")
    private Integer status;

    /**
     * 角色描述
     */
    @ApiModelProperty("角色描述，选填")
    private String description;

    /**
     * 用户ID
     */
    @ApiModelProperty(name = "用户ID，选填")
    private Long ownerId;

    /**
     * 父结点ID
     */
    @ApiModelProperty(name = "父结点ID，选填")
    private Long parentId;

    @ApiModelProperty(name = "组织ID")
    private Long belongOrgId;

    /**
     * 引用角色id
     */
    @ApiModelProperty(name = "引用角色id")
    private Long refRoleId;

    /**
     * 权限列表,限定菜单资源
     */
    @ApiModelProperty("权限列表, 引用标准角色的自定义角色，这里的权限才生效")
    private Set<AccessDto> accessSet;

    // region get、set
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getBelongOrgId() {
        return belongOrgId;
    }

    public void setBelongOrgId(Long belongOrgId) {
        this.belongOrgId = belongOrgId;
    }

    public Long getRefRoleId() {
        return refRoleId;
    }

    public void setRefRoleId(Long refRoleId) {
        this.refRoleId = refRoleId;
    }

    public Set<AccessDto> getAccessSet() {
        return accessSet;
    }

    public void setAccessSet(Set<AccessDto> accessSet) {
        this.accessSet = accessSet;
    }
    // endregion get、set
}
