/**
 * @(#)RoleModifyReqDto 1.0 2019/10/28
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author shuangqing  2019/10/28
 */
@ApiModel(value = "RoleModifyDto", description = "修改角色信息请求Dto")
public class RoleModifyReqDto extends BaseDto {

    /**
     * 角色名称
     */
    @ApiModelProperty("角色名称，选填")
    private String name;
    /**
     * 状态：1启用2禁用
     */
    @ApiModelProperty(name = "状态：1启用2禁用，默认1启用")
    private Integer status;
    /**
     * 角色描述
     */
    @ApiModelProperty("角色描述，选填")
    private String description;

    /**
     * 用户ID
     */
    @ApiModelProperty(name = "用户ID，选填")
    private Long ownerId;

    @ApiModelProperty(name = "组织ID")
    private Long orgId;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public RoleModifyReqDto setOrgId(Long orgId) {
        this.orgId = orgId;
        return this;
    }
}
