/**
 * @(#)RoleResourceRemoveReqDto 1.0 2019/10/30
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.yundt.cube.center.user.api.dto.AccessBaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author shuangqing  2019/10/30
 */
@ApiModel(value = "RoleResourceRemoveReqDto", description = "角色资源权限解除 请求dto")
public class RoleResourceRemoveReqDto extends BaseDto {

    @ApiModelProperty("角色code,必填")
    private String roleCode;

    @ApiModelProperty("角色id,选填，兼容旧逻辑")
    private Long roleId;

    @ApiModelProperty("权限资源列表，选填，不传则全量解除关联关系")
    private List<AccessBaseDto> accessBaseDtos;

    public String getRoleCode() {
        return roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public List<AccessBaseDto> getAccessBaseDtos() {
        return accessBaseDtos;
    }

    public void setAccessBaseDtos(List<AccessBaseDto> accessBaseDtos) {
        this.accessBaseDtos = accessBaseDtos;
    }
}
