/**
 * @(#) SortReqDto.java 1.0 2019-08-28
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 组织排序或菜单排序请求dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "SortReqDto", description = "组织排序或菜单排序请求dto")
public class SortReqDto implements Serializable {

    /**
     * 排序类型(BOTTOM：置底，INCR：升序，DECR：降序，TOP：置顶)
     */
    @NotNull
    @ApiModelProperty(value = "排序类型(BOTTOM：置底，INCR：升序，DECR：降序，TOP：置顶)")
    private String sortType;

    /**
     * 租户ID
     */
    @ApiModelProperty(value = "编码")
    private String code;

    /**
     * 实例ID
     */
    @ApiModelProperty(value = "实例ID")
    private Long instanceId;

    public String getSortType() {
        return sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }
}
