package com.dtyunxi.yundt.cube.center.user.api.dto.request.application;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;

/**
 * 应用的数据初始化状态更新请求
 * 如果指定instanceId, 请通过httpHeader传递
 *
 * @author zhang.youyang
 */
@ApiModel(value = "DataInstanceStatusUpdateReqDto", description = "应用的数据初始化状态 更新请求")
public class DataInstanceStatusUpdateReqDto extends BaseVo {

    @NotEmpty(message = "新状态必须指定")
    @ApiModelProperty(value = "更新的状态", required = true)
    private String newStatus;


    @ApiModelProperty(value = "更新前的状态.如果指定,则必须db中的状态跟请求的值完全一致才更新, 否则返回失败")
    private String originStatus;

    public String getNewStatus() {
        return newStatus;
    }

    public DataInstanceStatusUpdateReqDto setNewStatus(String newStatus) {
        this.newStatus = newStatus;
        return this;
    }

    public String getOriginStatus() {
        return originStatus;
    }

    public DataInstanceStatusUpdateReqDto setOriginStatus(String originStatus) {
        this.originStatus = originStatus;
        return this;
    }
}
