/**
 * @(#)MenuDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.response;

import com.dtyunxi.yundt.cube.center.user.api.dto.ResourceDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 菜单Dto
 * 用于菜单事件的数据传输对象
 *
 * @author 南枫
 * @since 1.0.0
 */
@ApiModel(value = "MenuDto", description = "菜单")
public class MenuQueryResDto extends ResourceDto {
    private static final long serialVersionUID = 1125806338598984432L;

    /**
     * 菜单名称(多语言字段1)
     */
    @ApiModelProperty(value = "菜单名称(多语言字段1)")
    private String name_i1;

    /**
     * 菜单名称(多语言字段2)
     */
    @ApiModelProperty(value = "菜单名称(多语言字段2)")
    private String name_i2;

    /**
     * 事件
     */
    @ApiModelProperty(value = "事件, 选填")
    private String action;
    /**
     * 父ID
     */
    @ApiModelProperty(value = "父id, 选填, 不填则为根节点")
    private String parentCode;
    /**
     * 路由路径
     */
    @ApiModelProperty(value = "路由路径, 选填", allowEmptyValue = true)
    private String routePath;

    /**
     * 页面ID
     */
    @ApiModelProperty(value = "页面ID")
    private String pageId;

    /**
     * 扩展
     */
    @ApiModelProperty(value = "扩展信息", allowEmptyValue = true)
    private String extension;
    /**
     * 子菜单
     */
    @ApiModelProperty(value = "子菜单")
    private List<MenuQueryResDto> children;

    private List<ButtonQueryResDto> buttons;
    @Override
    public String getAction() {
        return action;
    }

    @Override
    public void setAction(String action) {
        this.action = action;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    @Override
    public String getRoutePath() {
        return routePath;
    }

    @Override
    public void setRoutePath(String routePath) {
        this.routePath = routePath;
    }

    public String getPageId() {
        return pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public List<MenuQueryResDto> getChildren() {
        return children;
    }

    public void setChildren(List<MenuQueryResDto> children) {
        this.children = children;
    }

    public List<ButtonQueryResDto> getButtons() {
        return buttons;
    }

    public void setButtons(List<ButtonQueryResDto> buttons) {
        this.buttons = buttons;
    }

    public String getName_i1() {
        return name_i1;
    }

    public void setName_i1(String name_i1) {
        this.name_i1 = name_i1;
    }

    public String getName_i2() {
        return name_i2;
    }

    public void setName_i2(String name_i2) {
        this.name_i2 = name_i2;
    }
}
