/**
 * @(#) UserAccessVo.java 1.0 2018-06-20
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.response;

import com.dtyunxi.yundt.cube.center.user.api.dto.*;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Set;

/**
 * @author 黑马
 * @since 1.0.0
 */
@ApiModel("用户权限")
public class UserAccessRespDto extends BaseDto {
    /**
     * 用户Id
     */
    @ApiModelProperty(value = "用户Id")
    private Long userId;

    /**
     * 用户名/登录名
     */
    @ApiModelProperty(value = "用户名/登录名")
    private String userName;
    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称")
    private String nickName;

    /**
     * 角色列表
     */
    @ApiModelProperty(value = "角色列表")
    private Set<RoleDto> roleSet = Sets.newHashSet();
    /**
     * 权限列表
     */
    @ApiModelProperty(value = "权限列表")
    private Set<AccessDto> accessSet = Sets.newHashSet();

    /**
     * 菜单
     */
    @ApiModelProperty("菜单")
    private List<MenuDto> menus;

    /**
     * 按钮
     */
    @ApiModelProperty("按钮")
    private List<ButtonDto> buttons;

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public List<MenuDto> getMenus() {
        return menus;
    }

    public void setMenus(List<MenuDto> menus) {
        this.menus = menus;
    }

    public List<ButtonDto> getButtons() {
        return buttons;
    }

    public void setButtons(List<ButtonDto> buttons) {
        this.buttons = buttons;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Set<RoleDto> getRoleSet() {
        return roleSet;
    }

    public void setRoleSet(Set<RoleDto> roleSet) {
        this.roleSet = roleSet;
    }

    public Set<AccessDto> getAccessSet() {
        return accessSet;
    }

    public void setAccessSet(Set<AccessDto> accessSet) {
        this.accessSet = accessSet;
    }
}
