package com.dtyunxi.yundt.cube.center.user.api.dto.response;

import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @author qingzhu
 * @since 2.0.0
 * <p>
 * 用户响应dto(由于userDto太多冗余字段以及使用范围太广, 暂时根据当前业务需求创建对应字段, 若要作为其他接口的返回实体, 请自行添加需要的字段)
 */
public class UserRespDto extends ResponseDto {
    private static final long serialVersionUID = 2385311469644030648L;

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 用户账号
     */
    @ApiModelProperty(value = "用户账号")
    private String account;

    /**
     * 用户名
     */
    @ApiModelProperty(value = "用户名")
    private String userName;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱")
    private String email;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}
