package com.dtyunxi.yundt.cube.center.user.api.dto.vo;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ChartDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;

/**
 *
 * @author luban
 * @date 2020-06-18
 */
@ApiModel(description = "报表配置信息")
public class ChartDefinitionVo extends BaseDto {

    /**
     * 报表配置信息主键
     */
    @ApiModelProperty(value = "报表配置信息主键")
    private Long id;

    /**
     * 报表图标地址
     */
    @ApiModelProperty(value = "报表图标地址")
    private String icon;

    /**
     * 报表配置类型
     */
    @ApiModelProperty(value = "报表配置类型。 1-折线图， 2-竖状图，3-饼图")
    private String type;

    /**
     * 报表编码
     */
    @ApiModelProperty(value = "报表编码")
    private String chartCode;

    /**
     * 所属前端实例
     */
    @ApiModelProperty(value = "所属前端实例")
    private Long webInstance;

    /**
     * 自定义路径前缀
     * 完整url由4部分组成：域名 + 自定义路径前缀 + 网关配置服务前缀 + API路径
     */
    @Column(name = "url_prefix")
    private String urlPrefix;

    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    private Integer sort;

    @ApiModelProperty(value = "报表信息")
    private ChartDto chartDto;

    @ApiModelProperty(value = "配置值 (如果报表可配置，此处填写配置的值)")
    private String configValue;

    public ChartDto getChartDto() {
        return chartDto;
    }

    public void setChartDto(ChartDto chartDto) {
        this.chartDto = chartDto;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getChartCode() {
        return chartCode;
    }

    public void setChartCode(String chartCode) {
        this.chartCode = chartCode;
    }

    public Long getWebInstance() {
        return webInstance;
    }

    public void setWebInstance(Long webInstance) {
        this.webInstance = webInstance;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getUrlPrefix() {
        return urlPrefix;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public String getConfigValue() {
        return configValue;
    }

    public void setConfigValue(String configValue) {
        this.configValue = configValue;
    }
}
