/**
 * @(#) ImportUserResult.java 1.0 2018-12-19
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.vo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author 刘备
 * @since 1.0.0
 */
@Api(value = "导入用户结果")
public class ImportUserResult implements Serializable {

    /**
     * 导入成功的数据，key:用户名 value:用户ID
     */
    private Map<String, Long> successData = Maps.newHashMap();

    /**
     * 导入失败的数据
     */
    private List<Map<String, String>> errorData = Lists.newArrayList();

    @ApiModelProperty(name = "导入批次号")
    private String batch;

    @ApiModelProperty(name = "覆盖的信息数量")
    private int overrideCount;

    public Map<String, Long> getSuccessData() {
        return successData;
    }

    public void setSuccessData(Map<String, Long> successData) {
        this.successData = successData;
    }

    public List<Map<String, String>> getErrorData() {
        return errorData;
    }

    public void setErrorData(List<Map<String, String>> errorData) {
        this.errorData = errorData;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public int getOverrideCount() {
        return overrideCount;
    }

    public void setOverrideCount(int overrideCount) {
        this.overrideCount = overrideCount;
    }
}