/**
 * @(#) UserAccessVo.java 1.0 2018-06-20
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.vo;

import com.dtyunxi.yundt.cube.center.user.api.dto.AccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;

/**
 * @author 黑马
 * @since 1.0.0
 */
@ApiModel(description = "用户权限")
public class UserAccessVo extends BaseDto {
    private static final long serialVersionUID = -328292390308290515L;
    /**
     * 用户Id
     */
    @ApiModelProperty(value = "用户Id")
    private Long userId;
    /**
     * 用户名/登录名
     */
    @ApiModelProperty(value = "用户名/登录名")
    private String userName;
    /**
     * 角色列表
     */
    @ApiModelProperty(value = "角色列表")
    private Set<RoleDto> roleSet = Sets.newHashSet();
    /**
     * 权限列表
     */
    @ApiModelProperty(value = "权限列表")
    private Set<AccessDto> accessSet = Sets.newHashSet();

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Set<RoleDto> getRoleSet() {
        return roleSet;
    }

    public void setRoleSet(Set<RoleDto> roleSet) {
        this.roleSet = roleSet;
    }

    public Set<AccessDto> getAccessSet() {
        return accessSet;
    }

    public void setAccessSet(Set<AccessDto> accessSet) {
        this.accessSet = accessSet;
    }
}
