package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BillInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ContactsInfoDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.Size;
import java.util.List;

/**
 * @author yufan
 * @time 2020/9/28 10:50
 */
@Api(tags = {"用户中心：【客商中心】客户地址、发票信息、联系人信息查询服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-ICustomerUserQueryApi"
        , name = "${dtyunxi.yundt.cube_base-center-user_api.name:yundt-cube-center-user}"
        , path = "/v1/customer-user"
        , url = "${yundt.cube.center.user.api:}")
public interface ICustomerUserQueryApi {

    /**
     * 根据id,查询客户地址
     *
     * @param id 地址ID
     * @return AddressDto
     */
    @GetMapping(value = {"/address/get/{id}"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "根据id,查询客户地址", notes = "根据id,查询客户地址")
    @Capability(capabilityCode = "user.customer.address-query-by-id")
    RestResponse<AddressDto> queryAddressById(@PathVariable("id") Long id);

    /**
     * 根据组织信息id,查询客户地址列表
     *
     * @param orgInfoId    组织信息ID
     * @return AddressDtoList
     */
    @GetMapping(value = {"/address/by-orginfo/{orgInfoId}"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "根据组织信息id,查询客户地址列表", notes = "根据组织信息id,查询客户地址列表")
    @ApiImplicitParam(name = "orgInfoId", value = "组织信息id", paramType = "query")
    @Capability(capabilityCode = "user.customer.address-query-by-orginfo-list")
    RestResponse<List<AddressDto>> queryAddressListByOrgInfoId(@PathVariable("orgInfoId") Long orgInfoId);

    /**
     * 根据组织信息id列表,查询客户地址列表
     *
     * @param orgInfoIds    组织信息ID列表
     * @return AddressDtoList
     */
    @GetMapping(value = {"/address/get-by-orginfoids"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "根据组织信息id列表,查询客户地址列表", notes = "根据组织信息id列表,查询客户地址列表")
    @ApiImplicitParam(name = "orgInfoIds", value = "组织信息id列表", paramType = "query", allowMultiple = true)
    @Capability(capabilityCode = "user.customer.address-query-by-orginfo-list")
    RestResponse<List<AddressDto>> queryAddressListByOrgInfoIdList(@RequestParam("orgInfoIds")  List<Long> orgInfoIds);


    /**
     * 根据id,查询客户发票信息
     *
     * @param id 地址ID
     * @return BillInfoDto
     */
    @GetMapping(value = {"/billinfo/get/{id}"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "根据id,查询客户发票信息", notes = "根据id,查询客户发票信息")
    @Capability(capabilityCode = "user.customer.billinfo-query-by-id")
    RestResponse<BillInfoDto> queryBillInfoById(@PathVariable("id") Long id);

    /**
     * 根据组织信息id,查询客户发票信息
     *
     * @param orgInfoId    组织信息ID
     * @return BillInfoDtoList
     */
    @GetMapping(value = {"/billinfo/by-orginfo/{orgInfoId}"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "根据组织信息id,查询客户发票信息", notes = "根据组织信息id,查询客户发票信息")
    @ApiImplicitParam(name = "orgInfoId", value = "组织信息id", paramType = "query")
    @Capability(capabilityCode = "user.customer.billinfo-query-by-orginfo-list")
    RestResponse<List<BillInfoDto>> queryBillInfoListByOrgInfoId(@PathVariable("orgInfoId") Long orgInfoId);

    /**
     * 根据组织信息id列表,查询客户发票信息
     *
     * @param orgInfoIds    组织信息ID列表
     * @return BillInfoDtoList
     */
    @GetMapping(value = {"/billinfo/get-by-orginfoids"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "根据组织信息id列表,查询客户发票信息", notes = "根据组织信息id列表,查询客户发票信息")
    @ApiImplicitParam(name = "orgInfoIds", value = "组织信息id列表", paramType = "query", allowMultiple = true)
    @Capability(capabilityCode = "user.customer.billinfo-query-by-orginfo-list")
    RestResponse<List<BillInfoDto>> queryBillInfoListByOrgInfoIdList(@RequestParam("orgInfoIds")  List<Long> orgInfoIds);


    /**
     * 根据id,查询客户联系人
     *
     * @param id 地址ID
     * @return ContactsInfoDto
     */
    @GetMapping(value = {"/contacts/get/{id}"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "根据id,查询客户联系人", notes = "根据id,查询客户联系人")
    @Capability(capabilityCode = "user.customer.contacts-query-by-id")
    RestResponse<ContactsInfoDto> queryContactsInfoById(@PathVariable("id") Long id);

    /**
     * 根据组织信息id,查询客户联系人列表
     *
     * @param orgInfoId    组织信息ID
     * @return ContactsInfoDtoList
     */
    @GetMapping(value = {"/contacts/by-orginfo/{orgInfoId}"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "根据组织信息id,查询客户联系人列表", notes = "根据组织信息id,查询客户联系人列表")
    @ApiImplicitParam(name = "orgInfoId", value = "组织信息id", paramType = "query")
    @Capability(capabilityCode = "user.customer.contacts-query-by-orginfo-list")
    RestResponse<List<ContactsInfoDto>> queryContactsInfoListByOrgInfoId(@PathVariable("orgInfoId") Long orgInfoId);

    /**
     * 根据组织信息id列表,查询客户联系人列表
     *
     * @param orgInfoIds    组织信息ID列表
     * @return ContactsInfoDtoList
     */
    @GetMapping(value = {"/contacts/get-by-orginfoids"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "根据组织信息id列表,查询客户联系人列表", notes = "根据组织信息id列表,查询客户联系人列表")
    @ApiImplicitParam(name = "orgInfoIds", value = "组织信息id列表", paramType = "query", allowMultiple = true)
    @Capability(capabilityCode = "user.customer.contacts-query-by-orginfo-list")
    RestResponse<List<ContactsInfoDto>> queryContactsInfoListByOrgInfoIdList(@RequestParam("orgInfoIds")  List<Long> orgInfoIds);
}
