/**
 * @(#) IPersonalInfoQueryApi.java 1.0 2019/1/18
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.PersonalInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.PersonalInfoExtDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author 米修
 * @date 2019/1/18
 * @since 1.0.0
 */
@Api(tags = {"用户中心：个人信息查询服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-user-api-query-IPersonalInfoQueryApi",path = "/v1/personal-info", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface IPersonalInfoQueryApi {

    /**
     *
     * 根据个人信息id查询
     * @param id 个人信息id查询
     * @param filter 传入tenantId和instanceId
     * @return
     */
    @RequestMapping(value = {"/{id}"}, produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "根据个人信息id查询", notes = "根据个人信息id查询")
    @Capability(capabilityCode = "user.personal-info.query-byid")
    RestResponse<PersonalInfoExtDto> queryByid(@PathVariable("id") Long id, @RequestParam("filter") String filter);

    /**
     * 根据条件进行分页查询个人信息列表
     * @param filter 过滤条件
     * @param pageNum 页数
     * @param pageSize 每页的数量
     * @return
     */
    @RequestMapping(value = {"/page"}, produces = "application/json", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "filter", value = "查询条件json字符串,例如 {name:\"App1\"}", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    @ApiOperation(value = "分页查询个人信息列表（通用方法）", notes = "分页查询个人信息列表,filter为查询条件的json字符串，内容如下：\n" +
            "tenantId：租户ID\n" +
            "instanceId: 实例ID\n" +
            "filters:查询条件，由property、operator、value组成，分别代表属性、运算符(eq | ne | gt | lt | ge | le | like | in | isNull | isNotNull )、属性值\n" +
            "orderBy：升序字段,多个字段时逗号隔开\n" +
            "orderByDesc：降序字段,多个字段时逗号隔开\n" +
            "---------------------------------------------------------------------------------------------------\n" +
            "示例：\n" +
            "{\n" +
            "\t\"tenantId\": 1,\n" +
            "\t\"instanceId\": 1,\n" +
            "\t\"filters\": [{\n" +
            "\t\t\t\"property\": \"userName\",\n" +
            "\t\t\t\"operator\": \"like\",\n" +
            "\t\t\t\"value\": \"%liu%\"\n" +
            "\t\t},\n" +
            "\t\t{\n" +
            "\t\t\t\"property\": \"phone\",\n" +
            "\t\t\t\"operator\": \"eq\",\n" +
            "\t\t\t\"value\": \"158xxxxxx\"\n" +
            "\t\t}\n" +
            "\t],\n" +
            "\t\"orderBy\": \"createTime\",\n" +
            "\t\"orderByDesc\": \"id\",\n" +
            "}")
    @Capability(capabilityCode = "user.personal-info.query-by-page")
    RestResponse<PageInfo<PersonalInfoExtDto>> queryByPage(@RequestParam("filter") String filter, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

    /**
     * 根据sourceUID查询个人信息
     * @param sourceUid 外部服务的用户唯一标识UID
     * @param filter 传入tenantId和instanceId
     * @return
     */
    @RequestMapping(value = {"/sourceUid/{sourceUid}"}, produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "根据sourceUID查询个人信息", notes = "根据sourceUID查询个人信息")
    @Capability(capabilityCode = "user.personal-info.query-by-source-uid")
    RestResponse<PersonalInfoExtDto> queryBySourceUid(@PathVariable("sourceUid") Long sourceUid, @RequestParam("filter") String filter);


    /**
     * 根据个人信息的id集合批量查询
     * @param ids id的集合
     * @param filter 传入tenantId和instanceId
     * @return
     */
    @RequestMapping(value = {"/list"}, produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "根据个人信息的id集合批量查询", notes = "根据个人信息的id集合批量查询")
    @Capability(capabilityCode = "user.personal-info.query-byids")
    RestResponse<List<PersonalInfoExtDto>> queryByids(@RequestParam("ids") List<Long> ids, @RequestParam("filter") String filter);

    @RequestMapping(value = {"/getByPosition"}, produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "根据工号查个人信息", notes = "根据工号查个人信息")
    @Capability(capabilityCode = "user.personal-info.query-by-position")
    RestResponse<PersonalInfoDto> queryByPosition(@RequestParam("position") String position);
}
