/*
 * *
 *  * @(#)IUserBindingQueryApi.java 2.0.0 12/12/20, 10:20 AM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author luo.lei
 * @date 2020-12-12
 * @since 2.0.0
 */
@Api(tags = {"用户中心：用户第三方账号信息查询"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-query-IUserBindingQueryApi", path = "v1/user-binding", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface IUserBindingQueryApi {
    /**
     * 获取用户第三方信息凭证
     *
     * @param thirdPlatform 第三方类型 {@link com.dtyunxi.yundt.cube.center.user.api.constant.ThirdPlatform}
     * @return 第三方凭证，如查询微信则返回openId列表，根据绑定时间正序
     */
    @GetMapping(value = "/third-user-id")
    @ApiOperation(value = "获取用户第三方信息凭证", notes = "获取用户第三方信息凭证")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "thirdPlatform", value = "第三方类型")
    })
    RestResponse<List<String>> queryThirdUserId(@RequestParam("thirdPlatform") int thirdPlatform);


}
