package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserDomainQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserDomainRespDto;
import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 用户账号域查询服务接口
 *
 * @author qiuzhi
 * @since 2020-11-23
 */
@Api(tags = {"用户中心：用户账号域服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-IUserDomainQueryApi",
        name = "${dtyunxi.yundt.cube_base-center-user_api.name:yundt-cube-center-user}",
        url = "${yundt.cube.center.user.api:}",
        path = "/v2/user-domain"
)
public interface IUserDomainQueryApi {

    /**
     * 根据id查询用户账号域
     *
     * @param id 用户账号域id
     * @return   用户账号域数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询用户账号域", notes = "根据id查询用户账号域")
    @Capability(capabilityCode = "queryUserDomainById")
    RestResponse<UserDomainRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 用户账号域分页数据
     *
     * @param reqDto   用户账号域查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 用户账号域分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "用户账号域分页数据", notes = "根据查询条件查询用户账号域数据")
    @Capability(capabilityCode = "queryUserDomainByPage")
    RestResponse<PageInfo<UserDomainRespDto>> queryByPage(@SpringQueryMap UserDomainQueryReqDto reqDto,
                                                        @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                        @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
