/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.limit.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.datalimit.aop.DataLimitAspect;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.DataLimitConstant;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.IdentityTypeEnum;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.RuleTypeEnum;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.ValueTypeEnum;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.DataLimitIgnoreRuleCreateReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.DataLimitIgnoreRuleModifyReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.DataLimitRuleCreateReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.DataLimitRuleModifyReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.DataLimitRuleReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.ExpressionConfigDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.ExpressionConfigGroupDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.FuncReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.RuleConfigQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.RuleConfigReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.UserDataLimitRuleQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.DataLimitRuleRespDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.IgnoreRuleQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.IgnoreRuleQueryResDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.RuleConfigRespDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.UserDataLimitRuleQueryRespDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.exception.DataLimitExceptionCode;
import com.dtyunxi.yundt.cube.center.data.limit.biz.service.IDataLimitRuleIdlinkService;
import com.dtyunxi.yundt.cube.center.data.limit.biz.service.IDataLimitRuleService;
import com.dtyunxi.yundt.cube.center.data.limit.biz.service.IDataLimitRuleTmplService;
import com.dtyunxi.yundt.cube.center.data.limit.biz.service.IFieldLimitRuleService;
import com.dtyunxi.yundt.cube.center.data.limit.biz.util.DataLimitStringUtil;
import com.dtyunxi.yundt.cube.center.data.limit.biz.util.RegexUtil;
import com.dtyunxi.yundt.cube.center.data.limit.biz.vo.VarVo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.das.DataLimitRuleDas;
import com.dtyunxi.yundt.cube.center.data.limit.dao.das.DataLimitRuleIdlinkDas;
import com.dtyunxi.yundt.cube.center.data.limit.dao.das.DataLimitRuleVarDas;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.DataLimitRuleEo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.DataLimitRuleIdlinkEo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.DataLimitRuleVarEo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.StdDataLimitRuleEo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.StdDataLimitRuleIdlinkEo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.StdDataLimitRuleVarEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRoleRespDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.IExceptionEnum;
import com.dtyunxi.yundt.cube.center.user.biz.constant.RoleStatus;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.utils.PageInfoUtil;
import com.dtyunxi.yundt.cube.center.user.biz.vo.RoleQueryVo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class DataLimitRuleServiceImpl
implements IDataLimitRuleService {
    private static final Logger logger = LoggerFactory.getLogger(DataLimitRuleServiceImpl.class);
    @Resource
    private DataLimitRuleDas dataLimitRuleDas;
    @Resource
    private IDataLimitRuleTmplService dataLimitRuleTmplService;
    @Resource
    private DataLimitRuleVarDas dataLimitRuleVarDas;
    @Resource
    private DataLimitRuleIdlinkDas dataLimitRuleIdlinkDas;
    @Resource
    private IAccessService accessService;
    @Resource
    private IRoleService roleService;
    @Resource
    private IDataLimitRuleIdlinkService dataLimitRuleIdlinkService;
    @Resource
    private IFieldLimitRuleService fieldLimitRuleService;
    @Resource
    private ICacheService cacheService;
    @Value(value="${dtyunxi.yundt.cube.data.limit.user.rule.cache.enabled:false}")
    private boolean userRuleCacheEnabled;
    @Value(value="${dtyunxi.yundt.cube.data.limit.user.rule.cache.timeout:5}")
    private Integer userRuleCacheTimeout;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> addDataLimitRule(DataLimitRuleCreateReqDto addReqDto) {
        Long roleId = addReqDto.getRoleId();
        RoleDto roleDto = this.checkRole(roleId);
        Long instanceId = addReqDto.getInstanceId() == null ? ServiceContext.getContext().getRequestInstanceId() : addReqDto.getInstanceId();
        Long tenantId = addReqDto.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : addReqDto.getTenantId();
        List ruleConfigReqDtoList = addReqDto.getRuleConfigReqDtoList();
        ArrayList<Long> ruleIdList = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)ruleConfigReqDtoList)) {
            for (RuleConfigReqDto ruleConfigReqDto : ruleConfigReqDtoList) {
                ruleConfigReqDto.setIdentityIds((List)Lists.newArrayList((Object[])new Long[]{roleId}));
                DataLimitRuleEo dataLimitRuleEo = this.assembleDataLimitRuleEo(tenantId, instanceId, roleDto, ruleConfigReqDto);
                this.dataLimitRuleCheck(dataLimitRuleEo);
                this.dataLimitRuleDas.insert((BaseEo)dataLimitRuleEo);
                ruleConfigReqDto.setRuleId(dataLimitRuleEo.getId());
                this.expressionConfig(ruleConfigReqDto);
                ruleIdList.add(dataLimitRuleEo.getId());
            }
        }
        return ruleIdList;
    }

    private DataLimitRuleEo assembleDataLimitRuleEo(Long tenantId, Long instanceId, RoleDto roleDto, RuleConfigReqDto ruleConfigReqDto) {
        DataLimitRuleEo dataLimitRuleEo = new DataLimitRuleEo();
        dataLimitRuleEo.setTenantId(tenantId);
        dataLimitRuleEo.setInstanceId(instanceId);
        dataLimitRuleEo.setDomainCode(ruleConfigReqDto.getDomainCode());
        dataLimitRuleEo.setEntityCode(ruleConfigReqDto.getEntityCode());
        dataLimitRuleEo.setEntityName(ruleConfigReqDto.getEntityName());
        dataLimitRuleEo.setCode(this.generateRuleCode(roleDto.getCode(), dataLimitRuleEo));
        return dataLimitRuleEo;
    }

    private void dataLimitRuleCheck(DataLimitRuleEo dataLimitRuleEo) {
        DataLimitRuleEo query = new DataLimitRuleEo();
        query.setCode(dataLimitRuleEo.getCode());
        int existRuleCount = this.dataLimitRuleDas.count((BaseEo)query);
        logger.debug("ruleCode:{}", (Object)dataLimitRuleEo.getCode());
        AssertUtil.isTrue(existRuleCount == 0, DataLimitExceptionCode.DATA_LIMIT_RULE_EXISTS.getCode(), String.format(DataLimitExceptionCode.DATA_LIMIT_RULE_EXISTS.getMsg(), dataLimitRuleEo.getEntityCode()), new Object[0]);
    }

    private String generateRuleCode(String roleCode, DataLimitRuleEo dataLimitRuleEo) {
        String domainCode = dataLimitRuleEo.getDomainCode();
        String entityCode = dataLimitRuleEo.getEntityCode();
        return String.format("%s:%s:%s", roleCode, domainCode, entityCode);
    }

    private String generateIgnoreRuleCode(String sceneCode, String roleCode, String domainCode, String entityCode) {
        return String.format("%s:%s:%s:%s", sceneCode, roleCode, domainCode, entityCode);
    }

    @Override
    public void modifyDataLimitRule(DataLimitRuleModifyReqDto modifyReqDto) {
        Long roleId = modifyReqDto.getRoleId();
        RoleDto roleDto = this.checkRole(roleId);
        Long instanceId = modifyReqDto.getInstanceId() == null ? ServiceContext.getContext().getRequestInstanceId() : modifyReqDto.getInstanceId();
        Long tenantId = modifyReqDto.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : modifyReqDto.getTenantId();
        List ruleConfigReqDtoList = modifyReqDto.getRuleConfigReqDtoList();
        if (CollectionUtils.isNotEmpty((Collection)ruleConfigReqDtoList)) {
            for (RuleConfigReqDto ruleConfigReqDto : ruleConfigReqDtoList) {
                ruleConfigReqDto.setIdentityIds((List)Lists.newArrayList((Object[])new Long[]{roleId}));
                Long ruleId = ruleConfigReqDto.getRuleId();
                if (null == ruleId) {
                    DataLimitRuleEo dataLimitRuleEo = this.assembleDataLimitRuleEo(tenantId, instanceId, roleDto, ruleConfigReqDto);
                    this.dataLimitRuleCheck(dataLimitRuleEo);
                    this.dataLimitRuleDas.insert((BaseEo)dataLimitRuleEo);
                    ruleConfigReqDto.setRuleId(dataLimitRuleEo.getId());
                }
                this.expressionConfig(ruleConfigReqDto);
            }
        }
    }

    private RoleDto checkRole(Long roleId) {
        AssertUtil.isTrue(null != roleId, (IExceptionEnum)DataLimitExceptionCode.DATA_LIMIT_RULE_ROLE_ID_IS_NULL);
        RoleDto roleDto = this.roleService.queryRoleByRoleId(roleId);
        AssertUtil.isTrue(null != roleDto, (IExceptionEnum)DataLimitExceptionCode.DATA_LIMIT_RULE_ROLE_NOT_EXISTS);
        return roleDto;
    }

    private DataLimitRuleEo ruleParamCheck(Long ruleId) {
        DataLimitRuleEo ruleEo = (DataLimitRuleEo)this.dataLimitRuleDas.selectByPrimaryKey(ruleId);
        if (ruleEo == null) {
            throw new BizException(DataLimitExceptionCode.DATA_LIMIT_RULE_NOT_EXIST.getCode(), DataLimitExceptionCode.DATA_LIMIT_RULE_NOT_EXIST.getMsg());
        }
        return ruleEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDataLimitRule(Long id) {
        this.dataLimitRuleDas.logicDeleteById(id);
        DataLimitRuleVarEo ruleVarEo = new DataLimitRuleVarEo();
        ruleVarEo.setRuleId(id);
        this.dataLimitRuleVarDas.logicDeleteByExample((BaseEo)ruleVarEo);
        DataLimitRuleIdlinkEo ruleIdlinkEo = new DataLimitRuleIdlinkEo();
        ruleIdlinkEo.setRuleId(id);
        this.dataLimitRuleIdlinkDas.logicDeleteByExample((BaseEo)ruleIdlinkEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logicDeleteByRoleId(Long roleId) {
        DataLimitRuleIdlinkEo dataLimitRuleIdlinkEo = new DataLimitRuleIdlinkEo();
        dataLimitRuleIdlinkEo.setIdentityId(roleId);
        List dataLimitRuleIdlinkEos = this.dataLimitRuleIdlinkDas.select((BaseEo)dataLimitRuleIdlinkEo);
        if (CollectionUtils.isNotEmpty((Collection)dataLimitRuleIdlinkEos)) {
            ArrayList<Long> idlinkIds = new ArrayList<Long>();
            ArrayList<Long> ruleIds = new ArrayList<Long>();
            for (DataLimitRuleIdlinkEo limitRuleIdlinkEo : dataLimitRuleIdlinkEos) {
                idlinkIds.add(limitRuleIdlinkEo.getId());
                ruleIds.add(limitRuleIdlinkEo.getRuleId());
            }
            this.dataLimitRuleDas.logicDeleteByIds(ruleIds);
            this.dataLimitRuleIdlinkDas.logicDeleteByIds(idlinkIds);
            this.fieldLimitRuleService.logicDeleteFieldDetail(ruleIds);
        }
    }

    @Override
    public DataLimitRuleRespDto queryById(Long id) {
        DataLimitRuleEo dataLimitRuleEo = (DataLimitRuleEo)this.dataLimitRuleDas.selectByPrimaryKey(id);
        DataLimitRuleRespDto dataLimitRuleRespDto = new DataLimitRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)dataLimitRuleEo, (BaseVo)dataLimitRuleRespDto);
        this.setInfo(dataLimitRuleRespDto);
        return dataLimitRuleRespDto;
    }

    @Override
    public PageInfo<DataLimitRuleRespDto> queryByPage(DataLimitRuleReqDto reqDto, Integer pageNum, Integer pageSize) {
        Set ruleIdList = null;
        if (reqDto.getRoleId() != null) {
            List idLinkEoList = this.dataLimitRuleIdlinkDas.select(null, Collections.singleton(reqDto.getRoleId()), IdentityTypeEnum.ROLE.getCode());
            if (CollectionUtils.isNotEmpty((Collection)idLinkEoList)) {
                ruleIdList = idLinkEoList.stream().map(StdDataLimitRuleIdlinkEo::getRuleId).collect(Collectors.toSet());
            } else {
                return null;
            }
        }
        DataLimitRuleEo dataLimitRuleEo = new DataLimitRuleEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)dataLimitRuleEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (CollectionUtils.isNotEmpty(ruleIdList)) {
            dataLimitRuleEo.setId(null);
            sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ruleIdList, (String)",")));
        }
        dataLimitRuleEo.setSqlFilters(sqlFilters);
        dataLimitRuleEo.setOrderByDesc("entity_code");
        dataLimitRuleEo.setRuleType(RuleTypeEnum.DATA_LIMIT.getType());
        PageInfo eoPageInfo = this.dataLimitRuleDas.selectPage((BaseEo)dataLimitRuleEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DataLimitRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        for (DataLimitRuleRespDto ruleRespDto : dtoList) {
            this.setInfo(ruleRespDto);
        }
        return dtoPageInfo;
    }

    private void setRoleInfo(DataLimitRuleReqDto reqDto, List<DataLimitRuleRespDto> dtoList) {
        if (reqDto.getRoleId() != null) {
            List<RoleQueryVo> roleVoList = this.roleService.queryRoleAndAppInstanceByIds(Collections.singleton(reqDto.getRoleId()));
            if (CollectionUtils.isNotEmpty(roleVoList)) {
                dtoList.forEach(dto -> {
                    dto.setRoleId(((RoleQueryVo)roleVoList.get(0)).getId());
                    dto.setRoleName(((RoleQueryVo)roleVoList.get(0)).getName());
                    dto.setAppInsName(((RoleQueryVo)roleVoList.get(0)).getAppInsName());
                });
            }
        } else {
            for (DataLimitRuleRespDto ruleRespDto : dtoList) {
                List<RoleQueryVo> roleVoList;
                DataLimitRuleIdlinkEo idLinkEo = this.dataLimitRuleIdlinkDas.selectByRuleId(ruleRespDto.getId(), IdentityTypeEnum.ROLE.getCode());
                if (idLinkEo == null || !CollectionUtils.isNotEmpty(roleVoList = this.roleService.queryRoleAndAppInstanceByIds(Collections.singleton(idLinkEo.getIdentityId())))) continue;
                ruleRespDto.setRoleId(roleVoList.get(0).getId());
                ruleRespDto.setRoleName(roleVoList.get(0).getName());
                ruleRespDto.setAppInsName(roleVoList.get(0).getAppInsName());
            }
        }
    }

    private void setInfo(DataLimitRuleRespDto ruleRespDto) {
        DataLimitRuleIdlinkEo ruleIdlinkEo = this.dataLimitRuleIdlinkDas.selectByRuleId(ruleRespDto.getId(), IdentityTypeEnum.ROLE.getCode());
        if (ruleIdlinkEo != null) {
            if ("default".equals(ruleIdlinkEo.getSceneCode())) {
                ruleRespDto.setSceneCode(null);
            } else {
                ruleRespDto.setSceneCode(ruleIdlinkEo.getSceneCode());
            }
        }
    }

    @Override
    public UserDataLimitRuleQueryRespDto queryUserDataLimitRule(UserDataLimitRuleQueryReqDto reqDto) {
        Set<Long> roleIdList;
        List ruleList;
        Assert.notNull((Object)reqDto.getUserId(), (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notEmpty((Collection)reqDto.getEntityCodeList(), (String)"\u5b9e\u4f53\u7f16\u7801\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        UserDataLimitRuleQueryRespDto respDto = new UserDataLimitRuleQueryRespDto();
        String userRuleCacheKey = this.getUserRuleCacheKey(reqDto);
        if (this.userRuleCacheEnabled && null != (ruleList = (List)this.cacheService.getCache(userRuleCacheKey, (TypeReference)new TypeReference<List<UserDataLimitRuleQueryRespDto.RuleRespDto>>(){}))) {
            if (logger.isDebugEnabled()) {
                logger.debug("get user rule from cache, cacheKey:{}, rule:{}", (Object)userRuleCacheKey, (Object)JSONObject.toJSONString((Object)ruleList));
            }
            respDto.setRuleList(ruleList);
            return respDto;
        }
        Set customSkipTables = DataLimitAspect.readSkipTable();
        DataLimitAspect.skipAllTable();
        List<Object> ruleList2 = Lists.newArrayList();
        UserRoleReqDto userRoleReqDto = new UserRoleReqDto();
        userRoleReqDto.setUserId(reqDto.getUserId());
        Long instanceId = reqDto.getInstanceId() == null ? ServiceContext.getContext().getRequestInstanceId() : reqDto.getInstanceId();
        userRoleReqDto.setInstanceId(instanceId);
        List<UserRoleRespDto> userRoleRespDtoList = this.accessService.queryUserRole(userRoleReqDto);
        if (CollectionUtils.isNotEmpty(userRoleRespDtoList) && CollectionUtils.isNotEmpty(roleIdList = userRoleRespDtoList.stream().filter(role -> RoleStatus.ACTIVE.equals(role.getStatus())).map(UserRoleRespDto::getRoleId).collect(Collectors.toSet()))) {
            String sceneCode = StringUtils.isBlank((CharSequence)reqDto.getSceneCode()) ? "default" : reqDto.getSceneCode();
            List idlinkEoList = this.dataLimitRuleIdlinkDas.select(null, roleIdList, IdentityTypeEnum.ROLE.getCode(), sceneCode);
            if (CollectionUtils.isNotEmpty((Collection)idlinkEoList)) {
                ruleList2 = this.loadRule(reqDto, idlinkEoList);
            }
            this.setHasOtherSceneRule(reqDto, respDto, ruleList2, roleIdList);
        }
        if (this.userRuleCacheEnabled) {
            if (logger.isDebugEnabled()) {
                logger.debug("after query set user rule cache, cacheKey:{}, rule:{}", (Object)userRuleCacheKey, (Object)JSONObject.toJSONString((Object)ruleList2));
            }
            this.cacheService.setCache(userRuleCacheKey, (Object)ruleList2, this.userRuleCacheTimeout.intValue());
        }
        respDto.setRuleList((List)ruleList2);
        DataLimitAspect.cleanSkipTable();
        if (CollectionUtils.isNotEmpty((Collection)customSkipTables)) {
            DataLimitAspect.skipTables((String[])customSkipTables.toArray(new String[0]));
        }
        return respDto;
    }

    private void setHasOtherSceneRule(UserDataLimitRuleQueryReqDto reqDto, UserDataLimitRuleQueryRespDto respDto, List<UserDataLimitRuleQueryRespDto.RuleRespDto> ruleList, Set<Long> roleIdList) {
        Set ruleIds;
        int count;
        List idlinkEos;
        if (CollectionUtil.isEmpty(ruleList) && CollectionUtil.isNotEmpty((Collection)(idlinkEos = this.dataLimitRuleIdlinkDas.select(null, roleIdList, IdentityTypeEnum.ROLE.getCode()))) && (count = this.dataLimitRuleDas.count(ruleIds = idlinkEos.stream().map(StdDataLimitRuleIdlinkEo::getRuleId).collect(Collectors.toSet()), reqDto.getEntityCodeList(), RuleTypeEnum.DATA_LIMIT.getType())) > 0) {
            respDto.setHasOtherSceneRule(true);
        }
    }

    private List<UserDataLimitRuleQueryRespDto.RuleRespDto> loadRule(UserDataLimitRuleQueryReqDto reqDto, List<DataLimitRuleIdlinkEo> idlinkEoList) {
        ArrayList<UserDataLimitRuleQueryRespDto.RuleRespDto> ruleList = new ArrayList<UserDataLimitRuleQueryRespDto.RuleRespDto>();
        Set ruleIdList = idlinkEoList.stream().map(StdDataLimitRuleIdlinkEo::getRuleId).collect(Collectors.toSet());
        List ruleEoList = this.dataLimitRuleDas.select(ruleIdList, reqDto.getEntityCodeList(), RuleTypeEnum.DATA_LIMIT.getType());
        if (CollectionUtils.isNotEmpty((Collection)ruleEoList)) {
            for (DataLimitRuleEo ruleEo : ruleEoList) {
                if ("[]".equals(ruleEo.getExpression())) continue;
                UserDataLimitRuleQueryRespDto.RuleRespDto ruleRespDto = new UserDataLimitRuleQueryRespDto.RuleRespDto();
                ruleRespDto.setDomainCode(ruleEo.getDomainCode());
                ruleRespDto.setEntityCode(ruleEo.getEntityCode());
                ruleRespDto.setExpression(this.handleExpression(ruleEo));
                ruleList.add(ruleRespDto);
            }
        }
        return ruleList;
    }

    private String handleExpression(DataLimitRuleEo ruleEo) {
        String expression = this.handleExpressionVar(ruleEo);
        return this.handleExpressionRule(expression);
    }

    private String getUserRuleCacheKey(UserDataLimitRuleQueryReqDto reqDto) {
        Long userId = reqDto.getUserId();
        List entityList = reqDto.getEntityCodeList();
        StringBuilder userRuleCacheKey = new StringBuilder();
        userRuleCacheKey.append("UserDataLimitRule:").append(userId).append(":");
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            for (String entityName : entityList) {
                userRuleCacheKey.append("-").append(entityName);
            }
        }
        return userRuleCacheKey.toString();
    }

    private String handleExpressionVar(DataLimitRuleEo ruleEo) {
        List<String> funList;
        String expression = ruleEo.getExpression();
        List ruleVarEoList = this.dataLimitRuleVarDas.selectByRuleId(ruleEo.getId());
        if (CollectionUtils.isNotEmpty((Collection)ruleVarEoList)) {
            for (DataLimitRuleVarEo ruleVarEo : ruleVarEoList) {
                expression = expression.replaceAll(String.format("\\#\\{%s\\}", ruleVarEo.getVarCode()), ruleVarEo.getVarValue());
            }
        }
        if (CollectionUtils.isNotEmpty(funList = RegexUtil.getFunList(expression))) {
            for (String fun : funList) {
                expression = this.handleFunParam(expression, fun);
            }
        }
        expression = DataLimitStringUtil.replaceSystemSymbolWithBracket(expression);
        return expression;
    }

    private String handleFunParam(String expression, String fun) {
        List<String> funParamList = RegexUtil.getFunParamList(fun);
        if (CollectionUtils.isNotEmpty(funParamList)) {
            for (String param : funParamList) {
                if (!StringUtils.isNotEmpty((CharSequence)param)) continue;
                int size = param.split(",").length;
                StringBuilder paramValue = new StringBuilder();
                for (int i = 0; i < size; ++i) {
                    paramValue.append("CURRENT_USER_ID").append(",");
                }
                String pValue = paramValue.toString().substring(0, paramValue.toString().length() - 1);
                String value = fun.replaceAll(DataLimitStringUtil.escape(param), pValue);
                expression = expression.replace(DataLimitStringUtil.escape(fun), value);
            }
        }
        return expression;
    }

    private String handleExpressionRule(String expression) {
        List<Long> ruleIdList = RegexUtil.getRuleIdList(expression);
        if (CollectionUtils.isNotEmpty(ruleIdList)) {
            for (Long ruleId : ruleIdList) {
                DataLimitRuleEo ruleEo = this.ruleParamCheck(ruleId);
                String refExpression = this.handleExpression(ruleEo);
                expression = expression.replaceAll(String.format("\\{rule:%s\\}", ruleId.toString()), refExpression);
            }
        }
        return expression;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void expressionConfig(RuleConfigReqDto configReqDto) {
        Assert.notNull((Object)configReqDto.getRuleId(), (String)"\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notEmpty((Collection)configReqDto.getIdentityIds(), (String)"\u8eab\u4efdID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List expressionConfigGroups = configReqDto.getExpressionConfigGroups();
        Assert.notEmpty((Collection)expressionConfigGroups, (String)"\u903b\u8f91\u914d\u7f6e\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DataLimitRuleEo ruleEo = this.ruleParamCheck(configReqDto.getRuleId());
        this.saveIdLink(configReqDto.getIdentityIds(), configReqDto.getIdentityType(), ruleEo, configReqDto.getSceneCode());
        ArrayList tmplVarEoList = Lists.newArrayList();
        StringBuilder expression = this.dataLimitRuleTmplService.handleConfigGroups(expressionConfigGroups, ruleEo, tmplVarEoList, false);
        ruleEo.setExpression(expression.toString());
        this.dataLimitRuleDas.updateSelective((BaseEo)ruleEo);
    }

    private List<VarVo> handleConfigGroups(List<ExpressionConfigGroupDto> expressionConfigGroups, List<VarVo> varVoList) {
        for (ExpressionConfigGroupDto expressionConfigGroup : expressionConfigGroups) {
            List expressionConfigs = expressionConfigGroup.getExpressionConfigs();
            Assert.notEmpty((Collection)expressionConfigs, (String)"\u6570\u636e\u6743\u9650\u914d\u7f6e\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.handleConfigs(expressionConfigs, varVoList);
        }
        return varVoList;
    }

    private void handleConfigs(List<ExpressionConfigDto> expressionConfigs, List<VarVo> varVoList) {
        for (ExpressionConfigDto expressionConfig : expressionConfigs) {
            String dataType;
            Integer valueType = expressionConfig.getValueType();
            String defaultValue = expressionConfig.getDefaultValue();
            String string = dataType = expressionConfig.getDataType() == null ? "" : expressionConfig.getDataType();
            if (ValueTypeEnum.ASSOCIATIVE_TABLE.getType().equals(valueType)) {
                List children = expressionConfig.getChildren();
                if (!CollectionUtils.isNotEmpty((Collection)children)) continue;
                this.handleConfigGroups(children, varVoList);
                continue;
            }
            if (ValueTypeEnum.SYSTEM_DEFAULT.getType().equals(valueType)) {
                List attrCodes = expressionConfig.getAttrCodes();
                if (!CollectionUtils.isNotEmpty((Collection)attrCodes) || DataLimitConstant.NUMBER_SYMBOL.contains(dataType)) continue;
                attrCodes = attrCodes.stream().map(code -> DataLimitStringUtil.getStringValue(code)).collect(Collectors.toList());
                VarVo varVo = new VarVo();
                varVo.setVarValue(DataLimitStringUtil.getSystemValue(StringUtils.join(attrCodes, (String)",")));
                varVo.setVarCode(expressionConfig.getFieldCode());
                varVoList.add(varVo);
                continue;
            }
            if (ValueTypeEnum.FUNCTION.getType().equals(valueType)) {
                FuncReqDto funcReqDto = expressionConfig.getFunc();
                List paramList = null;
                if (null != funcReqDto) {
                    paramList = funcReqDto.getRequestParams();
                }
                if (!CollectionUtils.isNotEmpty(paramList)) continue;
                for (FuncReqDto.Param param : paramList) {
                    Assert.hasText((String)param.getName(), (String)"\u53c2\u6570\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    Assert.hasText((String)param.getValue(), (String)"\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    VarVo varVo = new VarVo();
                    varVo.setVarCode(param.getName());
                    String paramValue = param.getValue();
                    if (!DataLimitConstant.NUMBER_SYMBOL.contains(param.getType())) {
                        paramValue = DataLimitStringUtil.getStringValue(paramValue);
                    }
                    varVo.setVarValue(paramValue);
                    varVoList.add(varVo);
                }
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)defaultValue)) continue;
            VarVo varVo = new VarVo();
            varVo.setVarCode(expressionConfig.getFieldCode());
            if (!DataLimitConstant.NUMBER_SYMBOL.contains(dataType)) {
                defaultValue = DataLimitStringUtil.getStringValue(expressionConfig.getDefaultValue());
            }
            varVo.setVarValue(defaultValue);
            varVoList.add(varVo);
        }
    }

    private void saveIdLink(List<Long> identityIds, String identityType, DataLimitRuleEo ruleEo, String sceneCode) {
        if (StringUtils.isEmpty((CharSequence)identityType)) {
            identityType = IdentityTypeEnum.ROLE.getCode();
        } else {
            Assert.notNull((Object)IdentityTypeEnum.getDescByCode((String)identityType), (String)"\u8eab\u4efd\u7c7b\u578b\u9519\u8bef\uff01");
        }
        if (CollectionUtils.isNotEmpty(identityIds)) {
            ArrayList idLinkEoList = Lists.newArrayList();
            Set<Long> ruleIdList = this.getRuleIdList(ruleEo);
            ruleIdList.remove(ruleEo.getId());
            for (Long identityId : identityIds) {
                List idLinkEos;
                boolean isDefaultScene = StringUtils.isBlank((CharSequence)sceneCode);
                String string = sceneCode = isDefaultScene ? "default" : sceneCode;
                if (CollectionUtils.isNotEmpty(ruleIdList) && CollectionUtil.isNotEmpty((Collection)(idLinkEos = this.dataLimitRuleIdlinkDas.select(ruleIdList, Collections.singleton(identityId), identityType, sceneCode)))) {
                    if (isDefaultScene) {
                        throw new BizException(DataLimitExceptionCode.SCENE_CODE_DEFAULT_EXIST.getCode(), DataLimitExceptionCode.SCENE_CODE_DEFAULT_EXIST.getMsg());
                    }
                    throw new BizException(DataLimitExceptionCode.SCENE_FLAG_EXIST.getCode(), DataLimitExceptionCode.SCENE_FLAG_EXIST.getMsg());
                }
                DataLimitRuleIdlinkEo idLinkEo = new DataLimitRuleIdlinkEo();
                idLinkEo.setRuleId(ruleEo.getId());
                idLinkEo.setIdentityId(identityId);
                idLinkEo.setIdentityType(identityType);
                idLinkEo.setSceneCode(sceneCode);
                idLinkEoList.add(idLinkEo);
            }
            this.dataLimitRuleIdlinkDas.deleteByRuleId(ruleEo.getId(), identityType);
            this.dataLimitRuleIdlinkDas.insertBatch((List)idLinkEoList);
        }
    }

    @Override
    public RuleConfigRespDto queryExpression(RuleConfigQueryReqDto queryReqDto) {
        Set varValueSet;
        Assert.notNull((Object)queryReqDto.getRuleId(), (String)"\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DataLimitRuleEo ruleEo = this.ruleParamCheck(queryReqDto.getRuleId());
        RuleConfigRespDto respDto = new RuleConfigRespDto();
        respDto.setDataLimitRuleRespDto(this.queryById(queryReqDto.getRuleId()));
        String identityType = StringUtils.isEmpty((CharSequence)queryReqDto.getIdentityType()) ? IdentityTypeEnum.ROLE.getCode() : queryReqDto.getIdentityType();
        respDto.setIdentityIds(this.dataLimitRuleIdlinkService.queryIdentityIdList(queryReqDto.getRuleId(), identityType));
        List<ExpressionConfigGroupDto> expressionConfigGroups = this.dataLimitRuleTmplService.getConfigGroups(ruleEo.getExpression(), false, ruleEo.getId());
        respDto.setExpressionConfigGroups(expressionConfigGroups);
        List varEoList = this.dataLimitRuleVarDas.selectByRuleId(ruleEo.getId());
        if (CollectionUtils.isNotEmpty((Collection)varEoList) && CollectionUtils.isNotEmpty(varValueSet = varEoList.stream().filter(eo -> !StringUtils.isEmpty((CharSequence)eo.getVarValue())).map(StdDataLimitRuleVarEo::getVarValue).collect(Collectors.toSet()))) {
            Map<String, String> varCode2varValueMap = varEoList.stream().collect(Collectors.toMap(StdDataLimitRuleVarEo::getVarCode, StdDataLimitRuleVarEo::getVarValue, (s, a) -> s));
            this.setConfigGroups(expressionConfigGroups, varCode2varValueMap);
        }
        return respDto;
    }

    @Override
    public List<RuleConfigRespDto> queryExpressionPage(RuleConfigQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        Long roleId = queryReqDto.getRoleId();
        Assert.notNull((Object)roleId, (String)"\u89d2\u8272id\u4e3a\u7a7a");
        HashSet<Long> roleIdSet = new HashSet<Long>(32);
        roleIdSet.add(roleId);
        List ruleIdLinkEoList = this.dataLimitRuleIdlinkDas.select(null, roleIdSet, IdentityTypeEnum.ROLE.getCode(), "default");
        ArrayList<RuleConfigRespDto> ruleConfigRespDtoList = new ArrayList<RuleConfigRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)ruleIdLinkEoList)) {
            List ruleIdList = ruleIdLinkEoList.stream().map(StdDataLimitRuleIdlinkEo::getRuleId).collect(Collectors.toList());
            for (Long ruleId : ruleIdList) {
                RuleConfigQueryReqDto queryDto = new RuleConfigQueryReqDto();
                queryDto.setRuleId(ruleId);
                ruleConfigRespDtoList.add(this.queryExpression(queryDto));
            }
        }
        return ruleConfigRespDtoList;
    }

    private void setConfigGroups(List<ExpressionConfigGroupDto> expressionConfigGroups, Map<String, String> varCode2varValueMap) {
        for (ExpressionConfigGroupDto expressionConfigGroup : expressionConfigGroups) {
            List expressionConfigs = expressionConfigGroup.getExpressionConfigs();
            this.setConfigs(expressionConfigs, varCode2varValueMap);
        }
    }

    private void setConfigs(List<ExpressionConfigDto> expressionConfigs, Map<String, String> varCode2varValueMap) {
        for (ExpressionConfigDto expressionConfig : expressionConfigs) {
            Integer valueType = expressionConfig.getValueType();
            String defaultValue = expressionConfig.getDefaultValue();
            if (ValueTypeEnum.ASSOCIATIVE_TABLE.getType().equals(valueType)) {
                List children = expressionConfig.getChildren();
                if (!CollectionUtils.isNotEmpty((Collection)children)) continue;
                this.setConfigGroups(children, varCode2varValueMap);
                continue;
            }
            if (ValueTypeEnum.FUNCTION.getType().equals(valueType)) {
                List paramList;
                FuncReqDto funcReqDto = expressionConfig.getFunc();
                if (funcReqDto == null || !CollectionUtils.isNotEmpty((Collection)(paramList = funcReqDto.getRequestParams()))) continue;
                for (FuncReqDto.Param param : paramList) {
                    String value = varCode2varValueMap.get(param.getName());
                    if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                    param.setValue(value);
                }
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)defaultValue)) continue;
            String varValue = varCode2varValueMap.get(expressionConfig.getFieldCode());
            if (StringUtils.isNotEmpty((CharSequence)varValue)) {
                varValue = DataLimitStringUtil.replaceSymbol(varValue);
            }
            expressionConfig.setDefaultValue(varValue);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyRoleRule(Long sourceRoleId, Long targetRoleId) {
        this.check(sourceRoleId, targetRoleId);
        HashSet<Long> roleIdSet = new HashSet<Long>(16);
        roleIdSet.add(sourceRoleId);
        List dataLimitRuleIdLinkEoList = this.dataLimitRuleIdlinkDas.select(null, roleIdSet, IdentityTypeEnum.ROLE.getCode());
        if (CollectionUtils.isEmpty((Collection)dataLimitRuleIdLinkEoList)) {
            logger.info("\u6e90\u89d2\u8272 {} \u4e0b\u6ca1\u6709\u6570\u636e\u6743\u9650\u89c4\u5219\uff0c\u4e0d\u8fdb\u884c\u89c4\u5219\u7684\u590d\u5236", (Object)sourceRoleId);
            return;
        }
        HashSet ruleIdSet = Sets.newHashSet();
        HashMap<Long, List<DataLimitRuleVarEo>> ruleVarMap = new HashMap<Long, List<DataLimitRuleVarEo>>(32);
        HashMap<Long, DataLimitRuleIdlinkEo> ruleIdLinkMap = new HashMap<Long, DataLimitRuleIdlinkEo>(32);
        for (DataLimitRuleIdlinkEo link : dataLimitRuleIdLinkEoList) {
            Long ruleId = link.getRuleId();
            ruleIdSet.add(ruleId);
            List ruleVarEoList = this.dataLimitRuleVarDas.selectByRuleId(ruleId);
            if (CollectionUtils.isNotEmpty((Collection)ruleVarEoList)) {
                ruleVarMap.put(ruleId, ruleVarEoList);
            }
            Optional.ofNullable(this.dataLimitRuleIdlinkDas.selectByRuleId(ruleId, IdentityTypeEnum.ROLE.getCode())).ifPresent(e -> ruleIdLinkMap.put(ruleId, (DataLimitRuleIdlinkEo)e));
        }
        List dataLimitRuleEoList = this.dataLimitRuleDas.select((Set)ruleIdSet, null, RuleTypeEnum.DATA_LIMIT.getType());
        if (CollectionUtils.isEmpty((Collection)dataLimitRuleEoList)) {
            return;
        }
        this.copy(targetRoleId, ruleVarMap, ruleIdLinkMap, dataLimitRuleEoList);
    }

    private void copy(Long targetRoleId, Map<Long, List<DataLimitRuleVarEo>> ruleVarMap, Map<Long, DataLimitRuleIdlinkEo> ruleIdLinkMap, List<DataLimitRuleEo> dataLimitRuleEoList) {
        ArrayList newRuleIdLinkEoList = Lists.newArrayList();
        for (DataLimitRuleEo dataLimitRuleEo : dataLimitRuleEoList) {
            Long ruleId = dataLimitRuleEo.getId();
            dataLimitRuleEo.setId(null);
            this.dataLimitRuleDas.insert((BaseEo)dataLimitRuleEo);
            Long newRuleId = dataLimitRuleEo.getId();
            List<DataLimitRuleVarEo> ruleVarEoList = ruleVarMap.get(ruleId);
            if (CollectionUtils.isNotEmpty(ruleVarEoList)) {
                ruleVarEoList.forEach(e -> {
                    e.setId(null);
                    e.setRuleId(newRuleId);
                });
                this.dataLimitRuleVarDas.insertBatch(ruleVarEoList);
            }
            Optional.ofNullable(ruleIdLinkMap.get(ruleId)).ifPresent(e -> {
                e.setId(null);
                e.setRuleId(newRuleId);
                e.setIdentityId(targetRoleId);
                newRuleIdLinkEoList.add(e);
            });
        }
        this.dataLimitRuleIdlinkDas.insertBatch((List)newRuleIdLinkEoList);
    }

    private void check(Long sourceRoleId, Long targetRoleId) {
        RoleDto sourceRole = this.roleService.queryRoleByRoleId(sourceRoleId);
        Assert.notNull((Object)sourceRole, (String)"\u6e90\u89d2\u8272\u4e0d\u5b58\u5728");
        RoleDto targetRole = this.roleService.queryRoleByRoleId(targetRoleId);
        Assert.notNull((Object)targetRole, (String)"\u76ee\u6807\u89d2\u8272\u4e0d\u5b58\u5728");
        Assert.notNull((Object)sourceRole.getInstanceId(), (String)"\u6e90\u89d2\u8272\u7684\u5e94\u7528\u5b9e\u4f8bid\u4e3a\u7a7a");
        Assert.isTrue((boolean)sourceRole.getInstanceId().equals(targetRole.getInstanceId()), (String)"\u6e90\u89d2\u8272\u4e0e\u76ee\u6807\u89d2\u8272\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u4e2a\u5e94\u7528\u5b9e\u4f8b");
        HashSet<Long> targetRoleIdSet = new HashSet<Long>(16);
        targetRoleIdSet.add(targetRoleId);
        List targetRuleIdLinkEoList = this.dataLimitRuleIdlinkDas.select(null, targetRoleIdSet, IdentityTypeEnum.ROLE.getCode());
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)targetRuleIdLinkEoList), (String)"\u76ee\u6807\u89d2\u8272\u5df2\u7ecf\u5b58\u5728\u6570\u636e\u6743\u9650\u89c4\u5219\uff0c\u4e0d\u80fd\u8fdb\u884c\u590d\u5236\uff01");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyRoleRule(Long sourceRoleId, Long targetRoleId, boolean force) {
        if (force) {
            this.logicDeleteByRoleId(targetRoleId);
        }
        this.copyRoleRule(sourceRoleId, targetRoleId);
    }

    private Set<Long> getRuleIdList(DataLimitRuleEo ruleEo) {
        List ruleEoList = this.dataLimitRuleDas.selectByEntityCode(ruleEo.getDomainCode(), ruleEo.getEntityCode());
        Set<Object> ruleIdList = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)ruleEoList)) {
            ruleIdList = ruleEoList.stream().map(BaseEo::getId).collect(Collectors.toSet());
        }
        return ruleIdList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addIgnoreRule(DataLimitIgnoreRuleCreateReqDto addReqDto) {
        if (StringUtils.equals((CharSequence)"default", (CharSequence)addReqDto.getSceneCode())) {
            throw DataLimitExceptionCode.DATA_LIMIT_RULE_CANT_CUSTOM_RULS_SCENE.buildBizException();
        }
        Long roleId = addReqDto.getRoleId();
        RoleDto roleDto = this.checkRole(roleId);
        Long instanceId = Optional.ofNullable(addReqDto.getInstanceId()).orElseGet(() -> ((ServiceContext)ServiceContext.getContext()).getRequestInstanceId());
        Long tenantId = Optional.ofNullable(addReqDto.getTenantId()).orElseGet(() -> ((ServiceContext)ServiceContext.getContext()).getRequestTenantId());
        DataLimitRuleEo eo = new DataLimitRuleEo();
        eo.setTenantId(tenantId);
        eo.setInstanceId(instanceId);
        eo.setDomainCode(addReqDto.getDomainCode());
        eo.setEntityCode(addReqDto.getEntityCode());
        eo.setEntityName(addReqDto.getEntityName());
        eo.setStatus(Integer.valueOf(1));
        eo.setRuleType(RuleTypeEnum.DATA_LIMIT.getType());
        eo.setDr(0);
        String ignoreExpression = String.format("[%s.id > 0]", eo.getEntityCode());
        eo.setExpression(ignoreExpression);
        String code = this.generateIgnoreRuleCode(addReqDto.getSceneCode(), roleDto.getCode(), eo.getDomainCode(), eo.getEntityCode());
        DataLimitRuleEo foundEo = this.dataLimitRuleDas.findByCodeAndRuleType(code, RuleTypeEnum.DATA_LIMIT);
        if (foundEo != null) {
            throw DataLimitExceptionCode.DATA_LIMIT_RULE_EXISTS.buildBizException();
        }
        eo.setCode(code);
        this.dataLimitRuleDas.insert((BaseEo)eo);
        this.dataLimitRuleIdlinkService.addIgnoreRuleLink(eo.getId(), addReqDto.getSceneCode(), addReqDto.getRefAppInstId(), roleId, IdentityTypeEnum.ROLE);
        return eo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyIgnoreRule(DataLimitIgnoreRuleModifyReqDto modifyReqDto) {
        DataLimitRuleEo eo = (DataLimitRuleEo)this.dataLimitRuleDas.selectByPrimaryKey(modifyReqDto.getId());
        if (null == eo) {
            throw DataLimitExceptionCode.DATA_LIMIT_RULE_NOT_EXIST.buildBizException();
        }
        if (StringUtils.equals((CharSequence)"default", (CharSequence)modifyReqDto.getSceneCode())) {
            throw DataLimitExceptionCode.DATA_LIMIT_RULE_CANT_CUSTOM_RULS_SCENE.buildBizException();
        }
        Long roleId = modifyReqDto.getRoleId();
        RoleDto roleDto = this.checkRole(roleId);
        Long instanceId = Optional.ofNullable(modifyReqDto.getInstanceId()).orElseGet(() -> ((ServiceContext)ServiceContext.getContext()).getRequestInstanceId());
        Long tenantId = Optional.ofNullable(modifyReqDto.getTenantId()).orElseGet(() -> ((ServiceContext)ServiceContext.getContext()).getRequestTenantId());
        this.setIfNonNull(eo, BaseEo::setTenantId, tenantId);
        this.setIfNonNull(eo, BaseEo::setInstanceId, instanceId);
        this.setIfNonNull(eo, StdDataLimitRuleEo::setDomainCode, modifyReqDto.getDomainCode());
        this.setIfNonNull(eo, StdDataLimitRuleEo::setEntityCode, modifyReqDto.getEntityCode());
        this.setIfNonNull(eo, StdDataLimitRuleEo::setEntityName, modifyReqDto.getEntityName());
        String ignoreExpression = String.format("[%s.id > 0]", eo.getEntityCode());
        eo.setExpression(ignoreExpression);
        String code = this.generateIgnoreRuleCode(modifyReqDto.getSceneCode(), roleDto.getCode(), eo.getDomainCode(), eo.getEntityCode());
        DataLimitRuleEo foundEo = this.dataLimitRuleDas.findByCodeAndRuleType(code, RuleTypeEnum.DATA_LIMIT);
        if (foundEo != null && !foundEo.getId().equals(eo.getId())) {
            throw DataLimitExceptionCode.DATA_LIMIT_RULE_EXISTS.buildBizException();
        }
        eo.setCode(code);
        this.dataLimitRuleDas.update((BaseEo)eo);
        if (StringUtils.isBlank((CharSequence)modifyReqDto.getSceneCode()) && null == modifyReqDto.getRoleId()) {
            return;
        }
        this.dataLimitRuleIdlinkService.updateIgnoreRuleLink(eo.getId(), modifyReqDto.getSceneCode(), modifyReqDto.getRefAppInstId(), roleId, IdentityTypeEnum.ROLE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeIgnoreRule(Long id) {
        this.dataLimitRuleDas.findByIdAndRuleTypeOrElseThrow(id, RuleTypeEnum.DATA_LIMIT);
        this.dataLimitRuleDas.logicDeleteById(id);
        DataLimitRuleIdlinkEo linkEo = new DataLimitRuleIdlinkEo();
        linkEo.setRuleId(id);
        this.dataLimitRuleIdlinkDas.logicDelete((BaseEo)linkEo);
    }

    @Override
    public PageInfo<IgnoreRuleQueryResDto> queryIgnoreRuleByPage(IgnoreRuleQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo<DataLimitRuleIdlinkEo> ignoreRuleLinkEoPageInfo = this.dataLimitRuleIdlinkService.selectPageByIgnoreRule(queryReqDto, pageNum, pageSize);
        return PageInfoUtil.convert(ignoreRuleLinkEoPageInfo, this::linkEoToIgnoreRuleQueryResDto);
    }

    private IgnoreRuleQueryResDto linkEoToIgnoreRuleQueryResDto(DataLimitRuleIdlinkEo ruleLinkEo) {
        IgnoreRuleQueryResDto resDto = new IgnoreRuleQueryResDto();
        DataLimitRuleEo eo = this.dataLimitRuleDas.findByIdAndRuleType(ruleLinkEo.getRuleId(), RuleTypeEnum.DATA_LIMIT);
        if (eo != null) {
            CubeBeanUtils.copyProperties((Object)resDto, (Object)eo, (String[])new String[0]);
        }
        resDto.setSceneCode(ruleLinkEo.getSceneCode());
        IdentityTypeEnum identityTypeEnum = IdentityTypeEnum.fromCode((String)ruleLinkEo.getIdentityType());
        if (null == identityTypeEnum) {
            return resDto;
        }
        if (identityTypeEnum == IdentityTypeEnum.ROLE) {
            RoleDto roleDto = this.roleService.queryRoleByRoleId(ruleLinkEo.getIdentityId());
            if (roleDto == null) {
                return resDto;
            }
            resDto.setRoleId(roleDto.getId());
            resDto.setRoleName(roleDto.getName());
        }
        return resDto;
    }

    private <E, T> void setIfNonNull(E eo, BiConsumer<E, T> setFn, T t) {
        if (null == t) {
            return;
        }
        if (t instanceof String && StringUtils.isBlank((CharSequence)((String)t))) {
            return;
        }
        if (t instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)t))) {
            return;
        }
        setFn.accept(eo, t);
    }
}

