/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.apiimpl;

import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.IUserInfoApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BillInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ContactsInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.PersonalInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserInvoiceTitleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.DeviceReqDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.exception.BizException;
import com.dtyunxi.yundt.cube.center.user.biz.service.IPersonalInfoService;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="iUserInfoApi")
public class UserInfoApiImpl
implements IUserInfoApi {
    private Logger logger = LoggerFactory.getLogger(UserInfoApiImpl.class);
    @Autowired
    private IPersonalInfoService personalInfoService;

    public RestResponse<Long> addPersonalInfo(Long userId, PersonalInfoDto personalInfoDto) {
        Long id = this.personalInfoService.addPersonalInfo(userId, personalInfoDto);
        return new RestResponse((Object)id);
    }

    public RestResponse<Long> updatePersonalInfo(Long userId, Long personalInfoId, PersonalInfoDto personalInfoDto) {
        personalInfoDto.setId(personalInfoId);
        this.personalInfoService.updatePersonalInfo(userId, personalInfoDto);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Long> addBillInfo(Long userId, BillInfoDto billInfoDto) {
        Long id = this.personalInfoService.addBillInfo(userId, billInfoDto);
        return new RestResponse((Object)id);
    }

    public RestResponse<Long> updateBillInfo(Long userId, Long billInfoId, BillInfoDto billInfoDto) {
        billInfoDto.setId(billInfoId);
        this.personalInfoService.updateBillInfo(userId, billInfoDto);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> deleteBillInfo(Long billInfoId) {
        this.personalInfoService.deleteBillInfo(billInfoId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> setDefaultInvoiceTitle(UserInvoiceTitleDto userInvoiceTitleDto) {
        if (userInvoiceTitleDto == null || userInvoiceTitleDto.getBillInfoId() == null || userInvoiceTitleDto.getUserId() == null) {
            throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), "\u5fc5\u987b\u6307\u5b9auserId\u548c\u5f00\u7968\u4fe1\u606fid");
        }
        this.personalInfoService.setDefaultBillInfo(userInvoiceTitleDto);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addContactsInfo(Long userId, ContactsInfoDto contactsInfoDto) {
        Long id = this.personalInfoService.addContactsInfo(userId, contactsInfoDto);
        return new RestResponse((Object)id);
    }

    public RestResponse<Long> updateContactsInfo(Long userId, Long contactId, ContactsInfoDto contactsInfoDto) {
        contactsInfoDto.setId(contactId);
        this.personalInfoService.updateContactsInfo(userId, contactsInfoDto);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Long> deleteContactsInfo(Long contactsId) {
        this.personalInfoService.deleteContactsInfo(null, contactsId);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Long> deleteContactsInfoByUserIdAndContactsId(Long userId, Long contactsId) {
        return RestResponse.SUCCESS;
    }

    public RestResponse<Long> addAddress(Long userId, AddressDto addressDto) {
        Long id = this.personalInfoService.addAddress(userId, addressDto);
        return new RestResponse((Object)id);
    }

    public RestResponse<Long> updateAddress(Long userId, Long addressId, AddressDto addressDto) {
        addressDto.setId(addressId);
        this.personalInfoService.updateAddress(userId, addressDto);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Long> deleteAddress(Long addressId) {
        this.personalInfoService.deleteAddress(null, addressId);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Long> deleteAddressByUserIdAndAddressId(Long userId, Long addressId) {
        this.personalInfoService.deleteAddress(userId, addressId);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> setDefaultAddress(Long addressId) {
        this.personalInfoService.setDefaultAddress(null, addressId);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> setDefaultAddressByUserIdAndAddressId(Long userId, Long id) {
        this.personalInfoService.setDefaultAddress(userId, id);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Long> addDevice(DeviceReqDto deviceDto) {
        return new RestResponse((Object)this.personalInfoService.addDevice(deviceDto));
    }
}

