/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.cache;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.module.context.common.callback.IAppInstanceCallBack;
import com.dtyunxi.yundt.module.context.common.constants.ContextAppConstants;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class AppInstanceCacheUpdater {
    private static final Logger logger = LoggerFactory.getLogger(AppInstanceCacheUpdater.class);
    @Lazy
    @Autowired
    protected ICacheService cacheService;

    public void updateCache(AppInstanceEo appInstanceEo) {
        if (appInstanceEo == null) {
            return;
        }
        try {
            String appKeyKey = ContextAppConstants.combineKey((String)"APP_KEY", (String)appInstanceEo.getAppKey());
            String xRealHostnameKey = ContextAppConstants.combineKey((String)"REFERER_KEY", (String)IAppInstanceCallBack.removeProtocol((String)appInstanceEo.getServerName()));
            String refererKey = ContextAppConstants.combineKey((String)"REFERER_KEY", (String)IAppInstanceCallBack.removeProtocol((String)appInstanceEo.getHostName()));
            String xRealHostnameKeyNew = ContextAppConstants.combineKey((String)"HOST_KEY", (String)IAppInstanceCallBack.removeProtocol((String)appInstanceEo.getServerName()));
            String refererKeyNew = ContextAppConstants.combineKey((String)"HOST_KEY", (String)IAppInstanceCallBack.removeProtocol((String)appInstanceEo.getHostName()));
            HashMap waitCacheMap = Maps.newHashMap();
            waitCacheMap.put("APP_ID", String.valueOf(appInstanceEo.getApplicationId()));
            waitCacheMap.put("TENANT_ID", String.valueOf(appInstanceEo.getTenantId()));
            waitCacheMap.put("INSTANCE_ID", String.valueOf(appInstanceEo.getId()));
            if (StringUtils.isNotBlank((CharSequence)appKeyKey)) {
                this.cacheService.hmset("CONTEXT_APP_INSTANCE_GROUP", appKeyKey, (Map)waitCacheMap);
            }
            if (StringUtils.isNotBlank((CharSequence)xRealHostnameKey)) {
                this.cacheService.hmset("CONTEXT_APP_INSTANCE_GROUP", xRealHostnameKey, (Map)waitCacheMap);
            }
            if (StringUtils.isNotBlank((CharSequence)refererKey)) {
                this.cacheService.hmset("CONTEXT_APP_INSTANCE_GROUP", refererKey, (Map)waitCacheMap);
            }
            if (StringUtils.isNotBlank((CharSequence)xRealHostnameKeyNew)) {
                this.cacheService.hmset("CONTEXT_APP_INSTANCE_GROUP", xRealHostnameKeyNew, (Map)waitCacheMap);
            }
            if (StringUtils.isNotBlank((CharSequence)refererKeyNew)) {
                this.cacheService.hmset("CONTEXT_APP_INSTANCE_GROUP", refererKeyNew, (Map)waitCacheMap);
            }
        }
        catch (Exception e) {
            logger.warn("\u66f4\u65b0\u5e94\u7528\u4fe1\u606f\u7f13\u5b58\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void removeCache(AppInstanceEo appInstanceEo) {
        if (appInstanceEo != null) {
            String appKeyKey = ContextAppConstants.combineKey((String)"APP_KEY", (String)appInstanceEo.getAppKey());
            String xRealHostnameKey = ContextAppConstants.combineKey((String)"REFERER_KEY", (String)IAppInstanceCallBack.removeProtocol((String)appInstanceEo.getServerName()));
            String refererKey = ContextAppConstants.combineKey((String)"REFERER_KEY", (String)IAppInstanceCallBack.removeProtocol((String)appInstanceEo.getHostName()));
            String xRealHostnameKeyNew = ContextAppConstants.combineKey((String)"HOST_KEY", (String)IAppInstanceCallBack.removeProtocol((String)appInstanceEo.getServerName()));
            String refererKeyNew = ContextAppConstants.combineKey((String)"HOST_KEY", (String)IAppInstanceCallBack.removeProtocol((String)appInstanceEo.getHostName()));
            this.cacheService.hdel("CONTEXT_APP_INSTANCE_GROUP", appKeyKey, ContextAppConstants.FIELDS);
            this.cacheService.hdel("CONTEXT_APP_INSTANCE_GROUP", xRealHostnameKey, ContextAppConstants.FIELDS);
            this.cacheService.hdel("CONTEXT_APP_INSTANCE_GROUP", refererKey, ContextAppConstants.FIELDS);
            this.cacheService.hdel("CONTEXT_APP_INSTANCE_GROUP", xRealHostnameKeyNew, ContextAppConstants.FIELDS);
            this.cacheService.hdel("CONTEXT_APP_INSTANCE_GROUP", refererKeyNew, ContextAppConstants.FIELDS);
        }
    }
}

