/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AppResourceDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="APP_RESOURCE_TAG", msgType="single")
public class AppResourceProcessor
implements IMessageProcessor<AppResourceDto> {
    private static final Logger logger = LoggerFactory.getLogger(AppResourceProcessor.class);
    @Resource
    private IApplicationService applicationService;

    public MessageResponse process(AppResourceDto appResourceDto) {
        String resourceStr = JSON.toJSONString((Object)appResourceDto);
        try {
            logger.info("\u6536\u5230\u5e94\u7528\u8d44\u6e90\u6ce8\u518c\u6d88\u606f\uff1a{}", (Object)resourceStr);
            Long applicationId = this.applicationService.registerAppResource(appResourceDto);
            logger.info("\u521b\u5efa\u5e94\u7528\u6a21\u677f\u6210\u529f\uff0capplicationId = {}", (Object)applicationId);
            Long appInstanceId = this.applicationService.registerAppInstance(appResourceDto, applicationId);
            logger.info("\u521b\u5efa\u5e94\u7528\u5b9e\u4f8b\u6210\u529f\uff0cappInstanceId = {}", (Object)appInstanceId);
        }
        catch (Exception e) {
            logger.error("\u6ce8\u518c\u5e94\u7528\u8d44\u6e90\u5f02\u5e38", (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

