/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.processor;

import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.TenantDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.ITenantService;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Component
@MQDesc(tag="TENANT-INIT", msgType="publish")
public class TenantInitProcessor
implements IMessageProcessor {
    @Resource
    private ITenantService tenantService;

    public MessageResponse process(Object message) {
        TenantDto tenantDto = (TenantDto)message;
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        CompletableFuture.runAsync(() -> {
            RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
            this.tenantService.initTenant(tenantDto);
        });
        return MessageResponse.SUCCESS;
    }
}

