/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.limit.biz.service.IDataLimitRuleService;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleListDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IBizAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.utils.DataConverter;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleExtDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="bizAccessServiceImpl")
public class BizAccessServiceImpl
implements IBizAccessService {
    @Resource
    private RoleDas roleDas;
    @Resource
    private RoleExtDas roleExtDas;
    @Resource
    private IApplicationService applicationService;
    @Resource
    private IDataLimitRuleService dataLimitRuleService;

    @Override
    public List<RoleDto> queryRoleList(Long instanceId) {
        RoleEo roleEo = new RoleEo();
        roleEo.setInstanceId(instanceId);
        roleEo.setStatus(Integer.valueOf(1));
        List roleList = this.roleDas.select((BaseEo)roleEo);
        ArrayList<RoleDto> dtoList = new ArrayList<RoleDto>();
        DtoHelper.eoList2DtoList((Collection)roleList, dtoList, RoleDto.class);
        return dtoList;
    }

    @Override
    public RoleDto queryById(Long id) {
        RoleEo roleEo = new RoleEo();
        roleEo.setId(id);
        RoleEo eo = (RoleEo)this.roleDas.selectOne((BaseEo)roleEo);
        RoleDto dto = new RoleDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        return dto;
    }

    @Override
    public List<RoleDto> findByCodeOrName(Long instanceId, String code, String name) {
        RoleEo roleEo = new RoleEo();
        roleEo.setInstanceId(instanceId);
        if (StringUtils.isNotBlank((CharSequence)code)) {
            roleEo.setCode(code);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            roleEo.setName(name);
        }
        List eoList = this.roleDas.select((BaseEo)roleEo);
        ArrayList<RoleDto> roleDtoList = new ArrayList<RoleDto>();
        DtoHelper.eoList2DtoList((Collection)eoList, roleDtoList, RoleDto.class);
        return roleDtoList;
    }

    @Override
    public Long addRole(Long instanceId, RoleDto roleDto) {
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        AssertUtil.isTrue(null != instanceId, "Application-Key\u4e0d\u80fd\u4e3a\u7a7a");
        this.applicationService.assertAppInstanceExists(instanceId);
        RoleEo roleEo = new RoleEo();
        DtoHelper.dto2Eo((BaseVo)roleDto, (BaseEo)roleEo);
        if (roleEo.getStatus() == null) {
            roleEo.setStatus(Integer.valueOf(1));
        }
        roleEo.setInstanceId(instanceId);
        roleEo.setTenantId(tenantId);
        this.roleDas.insert((BaseEo)roleEo);
        return roleEo.getId();
    }

    @Override
    public PageInfo<RoleListDto> findList(Long instanceId, String code, String name, Integer pageNum, Integer pageSize) {
        PageInfo page = this.roleExtDas.findList(instanceId, code, name, pageNum, pageSize);
        return DataConverter.buildConverter().convertPageData(page, RoleListDto.class);
    }

    @Override
    public void deleteRole(Long id) {
        this.roleDas.logicDeleteById(id);
        this.dataLimitRuleService.logicDeleteByRoleId(id);
    }
}

