/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.ButtonDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.MenuDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IBizResourceService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.ButtonDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.MenuDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ButtonEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.MenuEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="bizResourceServiceImpl")
public class BizResourceServiceImpl
implements IBizResourceService {
    @Resource
    private MenuDas menuDas;
    @Resource
    private ButtonDas buttonDas;

    @Override
    public List<MenuDto> queryMenuByCode(String code) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)code), "\u53c2\u6570\u5f02\u5e38\uff01");
        MenuEo menuEo = new MenuEo();
        menuEo.setCode(code);
        List list = this.menuDas.select((BaseEo)menuEo);
        ArrayList<MenuDto> dtoList = new ArrayList<MenuDto>();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, MenuDto.class);
        return dtoList;
    }

    @Override
    public MenuDto queryMenuById(Long id) {
        AssertUtil.isTrue(id != null, "\u53c2\u6570\u5f02\u5e38\uff01");
        MenuEo menuEo = (MenuEo)this.menuDas.selectByPrimaryKey(id);
        MenuDto dto = new MenuDto();
        DtoHelper.eo2Dto((BaseEo)menuEo, (BaseVo)dto);
        return dto;
    }

    @Override
    public List<MenuDto> queryMenuByParentCode(String parentCode) {
        AssertUtil.isTrue(parentCode != null, "\u53c2\u6570\u5f02\u5e38\uff01");
        MenuEo menuEo = new MenuEo();
        menuEo.setParentCode(parentCode);
        menuEo.setOrderBy("sortNo");
        this.menuDas.select((BaseEo)menuEo);
        List list = this.menuDas.select((BaseEo)menuEo);
        ArrayList<MenuDto> dtoList = new ArrayList<MenuDto>();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, MenuDto.class);
        return dtoList;
    }

    @Override
    public List<ButtonDto> queryButtonByCode(String code) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)code), "\u53c2\u6570\u5f02\u5e38\uff01");
        ButtonEo buttonEo = new ButtonEo();
        buttonEo.setCode(code);
        List list = this.buttonDas.select((BaseEo)buttonEo);
        ArrayList<ButtonDto> dtoList = new ArrayList<ButtonDto>();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, ButtonDto.class);
        return dtoList;
    }
}

