/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.RegisterChannelDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRegisterChannelService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.RegisterChannelDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RegisterChannelEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RegisterChannelServiceImpl
implements IRegisterChannelService {
    @Resource
    private UserDas userDas;
    @Resource
    private RegisterChannelDas registerChannelDas;
    @Resource
    private IApplicationService applicationService;

    @Override
    public boolean checkCodeUnique(Long instanceId, String code) {
        return this.registerChannelDas.findByInstanceIdAndCode(instanceId, code) != null;
    }

    @Override
    public boolean checkNameUnique(Long instanceId, String name) {
        return this.registerChannelDas.findByInstanceIdAndName(instanceId, name) != null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> addChannelList(Long instanceId, Long userId, List<RegisterChannelDto> channelDtoList) {
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        UserEo owner = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(owner != null, "\u8be5\u7528\u6237[" + userId + "]\u4e0d\u5b58\u5728");
        RegisterChannelEo channelEo = null;
        ArrayList<Long> resultList = new ArrayList<Long>();
        for (RegisterChannelDto registerChannelDto : channelDtoList) {
            AssertUtil.isTrue(!this.checkCodeUnique(instanceId, registerChannelDto.getCode()), "\u5e94\u7528\u5b9e\u4f8b\u4e0b\u5df2\u5b58\u5728\u8be5\u6ce8\u518c\u6e20\u9053\uff0c\u6e20\u9053\u7f16\u7801\u4e3a\uff1a" + registerChannelDto.getCode());
            AssertUtil.isTrue(!this.checkNameUnique(instanceId, registerChannelDto.getName()), "\u5e94\u7528\u5b9e\u4f8b\u4e0b\u5df2\u5b58\u5728\u8be5\u6ce8\u518c\u6e20\u9053\uff0c\u6e20\u9053\u540d\u79f0\u4e3a\uff1a" + registerChannelDto.getName());
            registerChannelDto.setInstanceId(instanceId);
            registerChannelDto.setOwnerId(userId);
            registerChannelDto.setStatus(Integer.valueOf(1));
            channelEo = new RegisterChannelEo();
            DtoHelper.dto2Eo((BaseVo)registerChannelDto, (BaseEo)channelEo);
            channelEo.setOwnerId(userId);
            channelEo.setTenantId(tenantId);
            owner.setTenantId(tenantId);
            this.registerChannelDas.insert((BaseEo)channelEo);
            resultList.add(channelEo.getId());
        }
        return resultList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateRegisterChannel(Long channelId, RegisterChannelDto registerChannelDto) {
        RegisterChannelEo registerChannelEo = (RegisterChannelEo)this.registerChannelDas.selectByPrimaryKey(channelId);
        AssertUtil.isTrue(null != registerChannelEo, "\u6ce8\u518c\u6e20\u9053\u4fe1\u606f\u4e0d\u5b58\u5728");
        registerChannelEo = new RegisterChannelEo();
        DtoHelper.dto2Eo((BaseVo)registerChannelDto, (BaseEo)registerChannelEo, (String[])new String[]{"tenantId", "instanceId"});
        registerChannelEo.setId(channelId);
        this.registerChannelDas.updateSelective((BaseEo)registerChannelEo);
        return channelId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long deleteRegisterChannel(Long channelId) {
        this.registerChannelDas.logicDeleteById(channelId);
        return 1L;
    }

    @Override
    public RegisterChannelDto queryByChannelId(Long channelId) {
        RegisterChannelEo registerChannelEo = (RegisterChannelEo)this.registerChannelDas.selectByPrimaryKey(channelId);
        RegisterChannelDto registerChannelDto = null;
        if (registerChannelEo != null) {
            registerChannelDto = new RegisterChannelDto();
            DtoHelper.eo2Dto((BaseEo)registerChannelEo, (BaseVo)registerChannelDto);
            registerChannelDto.setOwnerId(registerChannelEo.getOwnerId());
        }
        return registerChannelDto;
    }

    @Override
    public List<RegisterChannelDto> queryChannelList(Long instanceId) {
        List registerChannelEos = this.registerChannelDas.findAllByInstanceId(instanceId);
        ArrayList registerChannelDtos = null;
        if (!CollectionUtils.isEmpty((Collection)registerChannelEos)) {
            registerChannelDtos = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)registerChannelEos, registerChannelDtos, RegisterChannelDto.class);
        }
        return registerChannelDtos;
    }

    @Override
    public PageInfo<RegisterChannelDto> queryChannelByExample(String filter, Integer pageNum, Integer pageSize) {
        RegisterChannelEo registerChannelEo = QueryUtil.validateExampleAndReturn(filter, RegisterChannelEo.class);
        PageInfo page = this.registerChannelDas.selectPage((BaseEo)registerChannelEo, pageNum, pageSize);
        return QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)page, RegisterChannelDto.class);
    }
}

