/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.exception.CenterDataExceptionCode;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AppInstanceDomainRemoveDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AppInstanceDomainReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.TenantDomainQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.TenantDomainRemoveDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.TenantDomainReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserDomainAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserDomainModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserDomainQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserDomainRespDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.exception.BizException;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserDomainService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.TenantDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDomainDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.TenantEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserDomainEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserDomainServiceImpl
implements IUserDomainService {
    @Resource
    private AppInstanceDas appInstanceDas;
    @Resource
    private TenantDas tenantDas;
    @Resource
    private IContext context;
    @Resource
    private UserDomainDas userDomainDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addUserDomain(UserDomainAddReqDto reqDto) {
        UserDomainEo userDomainEo = new UserDomainEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)userDomainEo);
        this.userDomainDas.insert((BaseEo)userDomainEo);
        return userDomainEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyUserDomain(UserDomainModifyReqDto reqDto) {
        AssertUtil.isTrue(reqDto.getId() != null, "id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        UserDomainEo queryEo = (UserDomainEo)this.userDomainDas.selectByPrimaryKey(reqDto.getId());
        if (queryEo == null) {
            throw new BusinessRuntimeException("500", "\u7528\u6237\u8d26\u53f7\u57df\u4e0d\u5b58\u5728");
        }
        UserDomainEo userDomainEo = new UserDomainEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)userDomainEo);
        this.userDomainDas.updateSelective((BaseEo)userDomainEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeUserDomain(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.userDomainDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public UserDomainRespDto queryById(Long id) {
        UserDomainEo userDomainEo = (UserDomainEo)this.userDomainDas.selectByPrimaryKey(id);
        if (userDomainEo == null) {
            return null;
        }
        UserDomainRespDto userDomainRespDto = new UserDomainRespDto();
        DtoHelper.eo2Dto((BaseEo)userDomainEo, (BaseVo)userDomainRespDto);
        return userDomainRespDto;
    }

    @Override
    public PageInfo<UserDomainRespDto> queryByPage(UserDomainQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        if (reqDto.getTenantId() == null) {
            reqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        }
        UserDomainEo userDomainEo = new UserDomainEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)userDomainEo);
        PageInfo eoPageInfo = this.userDomainDas.selectPage((BaseEo)userDomainEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, UserDomainRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setAppInstanceDomain(AppInstanceDomainReqDto appInstanceDomainReqDto) {
        AppInstanceEo appInstanceEo;
        Long instanceId = appInstanceDomainReqDto.getInstanceId();
        if (instanceId == null) {
            instanceId = this.context.instanceId();
        }
        AssertUtil.isTrue((appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId)) != null, UserExceptionCode.NON_EXIST_FAIL.getMsg());
        List domainList = appInstanceDomainReqDto.getDomainList();
        String defDomain = appInstanceDomainReqDto.getDefDomain();
        if (CollectionUtils.isEmpty((Collection)domainList) && StringUtils.isBlank((CharSequence)defDomain)) {
            defDomain = this.getTenantDefDomain(appInstanceEo.getTenantId());
        } else if (CollectionUtils.isNotEmpty((Collection)domainList) && StringUtils.isBlank((CharSequence)defDomain)) {
            throw new BizException(CenterDataExceptionCode.PARAM_INVALID.getCode(), "\u5fc5\u987b\u6307\u5b9a\u9ed8\u8ba4\u8d26\u53f7\u57df");
        }
        this.checkTenantExsitDomain(domainList, appInstanceEo.getTenantId(), defDomain);
        if (CollectionUtils.isNotEmpty((Collection)domainList)) {
            HashSet<String> domainSet = new HashSet<String>(domainList);
            String trustDomain = this.getTrustDomain(domainSet, defDomain);
            appInstanceEo.setTrustDomain(trustDomain);
        }
        appInstanceEo.setDefDomain(defDomain);
        this.appInstanceDas.updateSelective((BaseEo)appInstanceEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAppInstanceDomain(AppInstanceDomainRemoveDto appInstanceDomainRemoveDto) {
        AppInstanceEo appInstanceEo;
        List removeDomainList = appInstanceDomainRemoveDto.getDomainList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)removeDomainList), UserExceptionCode.NON_EXIST_FAIL.getMsg());
        Long instanceId = appInstanceDomainRemoveDto.getInstanceId();
        if (instanceId == null) {
            instanceId = this.context.instanceId();
        }
        AssertUtil.isTrue((appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId)) != null, UserExceptionCode.NON_EXIST_FAIL.getMsg());
        String trustDomain = appInstanceEo.getTrustDomain();
        String defDomain = appInstanceEo.getDefDomain();
        if (removeDomainList.contains(defDomain)) {
            defDomain = "default";
        }
        appInstanceEo.setDefDomain(defDomain);
        if (StringUtils.isNotBlank((CharSequence)trustDomain)) {
            String[] dbTrustDomain = trustDomain.split(",");
            ArrayList<String> updateDomain = new ArrayList<String>();
            for (String dbDomain : dbTrustDomain) {
                if (removeDomainList.contains(dbDomain)) continue;
                updateDomain.add(dbDomain);
            }
            if (CollectionUtils.isNotEmpty(updateDomain)) {
                String result = this.getTrustDomain(new HashSet<String>(updateDomain), defDomain);
                appInstanceEo.setTrustDomain(result);
            } else {
                appInstanceEo.setTrustDomain("");
            }
        }
        this.appInstanceDas.updateSelective((BaseEo)appInstanceEo);
    }

    @Override
    public void setTenantDomain(TenantDomainReqDto tenantDomainReqDto) {
        Set<String> appInstanceDomains;
        TenantEo tenantEo;
        Long tenantId = tenantDomainReqDto.getTenantId();
        if (tenantId == null) {
            tenantId = this.context.tenantId();
        }
        AssertUtil.isTrue((tenantEo = (TenantEo)this.tenantDas.selectByPrimaryKey(tenantId)) != null, UserExceptionCode.NON_EXIST_FAIL.getMsg());
        List domainList = tenantDomainReqDto.getDomainList();
        HashSet<String> dbDomain = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)tenantEo.getDefDomain())) {
            dbDomain.add(tenantEo.getDefDomain());
        }
        if (StringUtils.isNotBlank((CharSequence)tenantEo.getAvailableDomain())) {
            List<String> availableDomainArray = Arrays.asList(tenantEo.getAvailableDomain().split(","));
            dbDomain.addAll(availableDomainArray);
        }
        if (CollectionUtils.isNotEmpty(appInstanceDomains = this.getTenantDomainBindAppInstance(tenantId))) {
            HashSet<String> paramDomain = new HashSet<String>(domainList);
            paramDomain.add(tenantDomainReqDto.getDefDomain());
            for (String appInstanceDomain : appInstanceDomains) {
                if (!dbDomain.contains(appInstanceDomain) || paramDomain.contains(appInstanceDomain)) continue;
                throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), "\u4e0d\u80fd\u53d6\u6d88\u5df2\u5173\u8054\u5e94\u7528\u7684\u8d26\u53f7\u57df\uff1a" + appInstanceDomain);
            }
        }
        if (CollectionUtils.isEmpty((Collection)domainList) && StringUtils.isBlank((CharSequence)tenantDomainReqDto.getDefDomain())) {
            tenantEo.setDefDomain("default");
        } else if (CollectionUtils.isNotEmpty((Collection)domainList)) {
            String defDomain = tenantDomainReqDto.getDefDomain();
            if (StringUtils.isBlank((CharSequence)defDomain)) {
                defDomain = "default";
            }
            HashSet<String> domainSet = new HashSet<String>(domainList);
            String availableDomain = this.getTrustDomain(domainSet, defDomain);
            tenantEo.setAvailableDomain(availableDomain);
            tenantEo.setDefDomain(defDomain);
        }
        this.tenantDas.updateSelective((BaseEo)tenantEo);
    }

    @Override
    public void removeTenantDomain(TenantDomainRemoveDto tenantDomainRemoveDto) {
        TenantEo tenantEo;
        List removeDomainList = tenantDomainRemoveDto.getDomainList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)removeDomainList), UserExceptionCode.NON_EXIST_FAIL.getMsg());
        Long tenantId = tenantDomainRemoveDto.getTenantId();
        if (tenantId == null) {
            tenantId = this.context.tenantId();
        }
        AssertUtil.isTrue((tenantEo = (TenantEo)this.tenantDas.selectByPrimaryKey(tenantId)) != null, UserExceptionCode.NON_EXIST_FAIL.getMsg());
        Set<String> appInstanceDomains = this.getTenantDomainBindAppInstance(tenantId);
        if (CollectionUtils.isNotEmpty(appInstanceDomains)) {
            for (String appInstanceDomain : appInstanceDomains) {
                if (!removeDomainList.contains(appInstanceDomain)) continue;
                throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), "\u4e0d\u80fd\u53d6\u6d88\u5df2\u5173\u8054\u5e94\u7528\u7684\u8d26\u53f7\u57df\uff1a" + appInstanceDomain);
            }
        }
        String availableDomain = tenantEo.getAvailableDomain();
        String defDomain = tenantEo.getDefDomain();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{defDomain}) && removeDomainList.contains(defDomain)) {
            defDomain = "default";
        }
        tenantEo.setDefDomain(defDomain);
        if (StringUtils.isNotBlank((CharSequence)availableDomain)) {
            String[] dbAvailableDomainArray = availableDomain.split(",");
            ArrayList<String> updateDomain = new ArrayList<String>();
            for (String dbAvailableDomain : dbAvailableDomainArray) {
                if (removeDomainList.contains(dbAvailableDomain)) continue;
                updateDomain.add(dbAvailableDomain);
            }
            if (CollectionUtils.isNotEmpty(updateDomain)) {
                String result = this.getTrustDomain(new HashSet<String>(updateDomain), defDomain);
                tenantEo.setAvailableDomain(result);
            } else {
                tenantEo.setAvailableDomain("");
            }
        }
        this.tenantDas.updateSelective((BaseEo)tenantEo);
    }

    @Override
    public Set<String> queryTenantDomain(TenantDomainQueryReqDto tenantDomainQueryReqDto) {
        TenantEo tenantEo;
        Long tenantId = tenantDomainQueryReqDto.getTenantId();
        if (tenantId == null) {
            tenantId = this.context.tenantId();
        }
        AssertUtil.isTrue((tenantEo = (TenantEo)this.tenantDas.selectByPrimaryKey(tenantId)) != null, UserExceptionCode.NON_EXIST_FAIL.getMsg());
        String availableDomain = tenantEo.getAvailableDomain();
        String defDomain = tenantEo.getDefDomain();
        HashSet<String> domains = new HashSet<String>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{availableDomain})) {
            domains.addAll(Arrays.asList(availableDomain.split(",")));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{defDomain})) {
            domains.add(defDomain);
        }
        return domains;
    }

    private String getTrustDomain(Set<String> domainSet, String defDomain) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String domain : domainSet) {
            if (domain.equals(defDomain)) continue;
            stringBuilder.append(domain);
            stringBuilder.append(",");
        }
        String trustDomain = stringBuilder.toString();
        if (trustDomain.endsWith(",") && trustDomain.length() > 1) {
            return trustDomain.substring(0, trustDomain.length() - 1);
        }
        return null;
    }

    private void checkTenantExsitDomain(List<String> domains, Long tenantId, String appInstanceDefDomain) {
        domains.add(appInstanceDefDomain);
        TenantEo tenantEo = (TenantEo)this.tenantDas.selectByPrimaryKey(tenantId);
        AssertUtil.isTrue(tenantEo != null, "\u79df\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        String availableDomain = tenantEo.getAvailableDomain();
        String defDomain = tenantEo.getDefDomain();
        ArrayList<String> result = new ArrayList<String>();
        result.add(defDomain);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{availableDomain})) {
            result.addAll(Arrays.asList(availableDomain.split(",")));
        }
        for (String domain : domains) {
            if (result.contains(domain)) continue;
            throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), "\u79df\u6237\u4e0d\u5b58\u5728\u5e10\u53f7\u57df\uff1a" + domain);
        }
    }

    private String getTenantDefDomain(Long tenantId) {
        TenantEo tenantEo = (TenantEo)this.tenantDas.selectByPrimaryKey(tenantId);
        AssertUtil.isTrue(tenantEo != null, "\u5bf9\u5e94\u79df\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        return tenantEo.getDefDomain();
    }

    private Set<String> getTenantDomainBindAppInstance(Long tenantId) {
        AppInstanceEo appInstanceEo = new AppInstanceEo();
        appInstanceEo.setTenantId(tenantId);
        List appInstanceEos = this.appInstanceDas.select((BaseEo)appInstanceEo);
        HashSet<String> appInstanceDomains = new HashSet<String>();
        if (CollectionUtils.isNotEmpty((Collection)appInstanceEos)) {
            for (AppInstanceEo eo : appInstanceEos) {
                if (StringUtils.isNotBlank((CharSequence)eo.getDefDomain())) {
                    appInstanceDomains.add(eo.getDefDomain());
                }
                if (!StringUtils.isNotBlank((CharSequence)eo.getTrustDomain())) continue;
                List<String> trustDomainArray = Arrays.asList(eo.getTrustDomain().split(","));
                appInstanceDomains.addAll(trustDomainArray);
            }
        }
        return appInstanceDomains;
    }
}

