/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.RelationInfoDto;
import com.dtyunxi.yundt.cube.center.user.biz.constant.UserConstants;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserRelationService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserRelationEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserRelationServiceImpl
implements IUserRelationService {
    @Autowired
    private UserRelationDas userRelationDas;
    @Resource
    private UserDas userDas;
    @Resource
    private IApplicationService applicationService;

    @Override
    public void bindUserRelation(Long instanceId, Long firstUserId, Long secondUserId, Integer relationType) {
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        UserRelationEo userRelationEo = this.findUserRelation(instanceId, firstUserId, secondUserId, relationType);
        AssertUtil.isTrue(userRelationEo == null, "\u8be5\u5b9e\u4f8b\u4e0b\u6b64\u7528\u6237\u5173\u7cfb\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u7ed1\u5b9a");
        this.applicationService.assertAppInstanceExists(instanceId);
        UserEo firstUser = (UserEo)this.userDas.selectByPrimaryKey(firstUserId);
        UserEo secondUser = (UserEo)this.userDas.selectByPrimaryKey(secondUserId);
        AssertUtil.isTrue(null != firstUser, "\u7528\u6237ID[" + firstUserId + "]\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(null != secondUser, "\u7528\u6237ID[" + secondUserId + "]\u4e0d\u5b58\u5728");
        UserRelationEo userRelation = new UserRelationEo();
        userRelation.setInstanceId(instanceId);
        userRelation.setFirstUserId(firstUserId);
        userRelation.setSecondUserId(secondUserId);
        userRelation.setRelationType(UserConstants.RelationType.TYPE(relationType));
        userRelation.setTenantId(tenantId);
        this.userRelationDas.insert((BaseEo)userRelation);
    }

    @Override
    public void unbindUserRelation(Long instanceId, Long firstUserId, Long secondUserId, Integer relationType) {
        UserRelationEo userRelationEo = this.findUserRelation(instanceId, firstUserId, secondUserId, relationType);
        AssertUtil.isTrue(null != userRelationEo, "\u7528\u6237\u5173\u7cfb\u4e0d\u5b58\u5728");
        UserRelationEo eo = new UserRelationEo();
        eo.setId(userRelationEo.getId());
        eo.setFirstUserId(firstUserId);
        this.userRelationDas.logicDelete((BaseEo)eo);
    }

    @Override
    public UserRelationEo findUserRelation(Long instanceId, Long firstUserId, Long secondUserId, Integer relationType) {
        return this.userRelationDas.findUserRelation(instanceId, firstUserId, secondUserId, UserConstants.RelationType.TYPE(relationType));
    }

    @Override
    public PageInfo<RelationInfoDto> queryRelationInfo(String filter, Integer pageNum, Integer pageSize) {
        PageInfo eoPageInfo;
        List userRelationEoList;
        ArrayList relationInfoDtoList = Lists.newArrayList();
        PageInfo dtoPageInfo = new PageInfo((List)relationInfoDtoList);
        UserRelationEo userRelationEo = (UserRelationEo)ObjectHelper.Json2Bean((String)filter, UserRelationEo.class);
        AssertUtil.isTrue(userRelationEo != null, "filter\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((CharSequence)userRelationEo.getRelationType())) {
            userRelationEo.setRelationType(UserConstants.RelationType.TYPE(Integer.parseInt(userRelationEo.getRelationType())));
        }
        if ((userRelationEoList = (eoPageInfo = this.userRelationDas.selectPage((BaseEo)userRelationEo, pageNum, pageSize)).getList()) != null && userRelationEoList.size() > 0) {
            for (UserRelationEo userRelation : userRelationEoList) {
                RelationInfoDto relationInfoDto = new RelationInfoDto();
                CubeBeanUtils.copyProperties((Object)relationInfoDto, (Object)userRelation, (String[])new String[0]);
                UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userRelation.getFirstUserId());
                AssertUtil.isTrue(userEo != null, "\u4e0d\u5b58\u5728" + userRelation.getFirstUserId() + "\u4fe1\u606f");
                CubeBeanUtils.copyProperties((Object)relationInfoDto, (Object)userEo, (String[])new String[]{"createTime", "extension"});
                relationInfoDtoList.add(relationInfoDto);
            }
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        }
        return dtoPageInfo;
    }
}

