/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.limit.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.DataLimitConstant;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.LogicalOperatorEnum;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.RelationalOperatorEnum;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.ValueTypeEnum;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.DataLimitRuleTmplCreateReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.DataLimitRuleTmplFuncReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.DataLimitRuleTmplModifyReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.DataLimitRuleTmplReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.ExpressionConfigDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.ExpressionConfigGroupDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.FuncReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.DataLimitRuleTmplFuncRespDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.DataLimitRuleTmplRespDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.exception.DataLimitExceptionCode;
import com.dtyunxi.yundt.cube.center.data.limit.biz.service.IDataLimitRuleTmplService;
import com.dtyunxi.yundt.cube.center.data.limit.biz.util.DataLimitStringUtil;
import com.dtyunxi.yundt.cube.center.data.limit.biz.util.RegexUtil;
import com.dtyunxi.yundt.cube.center.data.limit.biz.vo.RuleTmplVarVo;
import com.dtyunxi.yundt.cube.center.data.limit.biz.vo.VarVo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.das.DataLimitRuleTmplDas;
import com.dtyunxi.yundt.cube.center.data.limit.dao.das.DataLimitRuleTmplFuncDas;
import com.dtyunxi.yundt.cube.center.data.limit.dao.das.DataLimitRuleVarDas;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.DataLimitRuleEo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.DataLimitRuleTmplEo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.DataLimitRuleTmplFuncEo;
import com.dtyunxi.yundt.cube.center.user.api.exception.IExceptionEnum;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class DataLimitRuleTmplServiceImpl
implements IDataLimitRuleTmplService {
    private static Logger logger = LoggerFactory.getLogger(DataLimitRuleTmplServiceImpl.class);
    @Resource
    private DataLimitRuleTmplDas dataLimitRuleTmplDas;
    @Resource
    private DataLimitRuleVarDas dataLimitRuleVarDas;
    @Resource
    private DataLimitRuleTmplFuncDas dataLimitRuleTmplFuncDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addDataLimitRuleTmpl(DataLimitRuleTmplCreateReqDto addReqDto) {
        String code = this.generateCode(addReqDto.getTmplType(), addReqDto.getRefAppInstId(), addReqDto.getDomainCode(), addReqDto.getEntityCode(), addReqDto.getFieldCode());
        addReqDto.setCode(code);
        this.createDataLimitRuleTmplParamCheck(addReqDto);
        DataLimitRuleTmplEo dataLimitRuleTmplEo = new DataLimitRuleTmplEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)dataLimitRuleTmplEo);
        this.dataLimitRuleTmplDas.insert((BaseEo)dataLimitRuleTmplEo);
        List funcReqDtoList = addReqDto.getFuncReqDtoList();
        if (!CollectionUtils.isEmpty((Collection)funcReqDtoList)) {
            ArrayList funcEoList = new ArrayList();
            DtoHelper.dtoList2EoList((Collection)funcReqDtoList, funcEoList, DataLimitRuleTmplFuncEo.class);
            funcEoList.stream().forEach(e -> e.setTmplId(dataLimitRuleTmplEo.getId()));
            this.dataLimitRuleTmplFuncDas.insertBatch(funcEoList);
        }
        return dataLimitRuleTmplEo.getId();
    }

    private String generateCode(Integer tmplType, Long refAppInstId, String domainCode, String entityCode, String fieldCode) {
        String code = DataLimitConstant.RULE_TYPE_DATA_LIMIT.equals(tmplType) ? String.format("%d:%s:%s:%s", refAppInstId, domainCode, entityCode, fieldCode) : String.format("%d:%s", refAppInstId, fieldCode);
        return code;
    }

    private void createDataLimitRuleTmplParamCheck(DataLimitRuleTmplCreateReqDto createReqDto) {
        Integer tmplType = createReqDto.getTmplType();
        String code = createReqDto.getCode();
        this.dataLimitRuleTmplParamCheck(createReqDto.getUseFunc(), createReqDto.getFuncReqDtoList());
        DataLimitRuleTmplEo query = new DataLimitRuleTmplEo();
        query.setCode(code);
        query.setTmplType(tmplType);
        int existsTmplCount = this.dataLimitRuleTmplDas.count((BaseEo)query);
        AssertUtil.isTrue(existsTmplCount == 0, (IExceptionEnum)DataLimitExceptionCode.DATA_LIMIT_RULE_TMPL_CODE_EXIST);
    }

    private void modifyDataLimitRuleTmplParamCheck(DataLimitRuleTmplModifyReqDto modifyReqDto) {
        this.dataLimitRuleTmplParamCheck(modifyReqDto.getUseFunc(), modifyReqDto.getFuncReqDtoList());
    }

    private void dataLimitRuleTmplParamCheck(Integer useFunc, List<DataLimitRuleTmplFuncReqDto> funcReqDtoList) {
        if (DataLimitConstant.USE_FUNC.equals(useFunc)) {
            Assert.notEmpty(funcReqDtoList, (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u9879\u51fd\u6570");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyDataLimitRuleTmpl(DataLimitRuleTmplModifyReqDto modifyReqDto) {
        modifyReqDto.setCode(this.generateCode(modifyReqDto.getTmplType(), modifyReqDto.getRefAppInstId(), modifyReqDto.getDomainCode(), modifyReqDto.getEntityCode(), modifyReqDto.getFieldCode()));
        this.modifyDataLimitRuleTmplParamCheck(modifyReqDto);
        DataLimitRuleTmplEo dataLimitRuleTmplEo = new DataLimitRuleTmplEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)dataLimitRuleTmplEo);
        this.dataLimitRuleTmplDas.updateSelective((BaseEo)dataLimitRuleTmplEo);
        this.updateDataLimitFunc(modifyReqDto);
    }

    private void updateDataLimitFunc(DataLimitRuleTmplModifyReqDto modifyReqDto) {
        DataLimitRuleTmplFuncEo dataLimitRuleTmplFuncEo = new DataLimitRuleTmplFuncEo();
        dataLimitRuleTmplFuncEo.setTmplId(modifyReqDto.getId());
        this.dataLimitRuleTmplFuncDas.deleteByExample((BaseEo)dataLimitRuleTmplFuncEo);
        if (DataLimitConstant.USE_FUNC.equals(modifyReqDto.getUseFunc())) {
            ArrayList funcEoList = new ArrayList();
            List funcReqDtoList = modifyReqDto.getFuncReqDtoList();
            DtoHelper.dtoList2EoList((Collection)funcReqDtoList, funcEoList, DataLimitRuleTmplFuncEo.class);
            funcEoList.forEach(e -> e.setTmplId(modifyReqDto.getId()));
            this.dataLimitRuleTmplFuncDas.insertBatch(funcEoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDataLimitRuleTmpl(Long id) {
        DataLimitRuleTmplEo tmplEo = new DataLimitRuleTmplEo();
        tmplEo.setId(id);
        this.dataLimitRuleTmplDas.logicDelete((BaseEo)tmplEo);
    }

    @Override
    public DataLimitRuleTmplRespDto queryById(Long id) {
        DataLimitRuleTmplEo dataLimitRuleTmplEo = (DataLimitRuleTmplEo)this.dataLimitRuleTmplDas.selectByPrimaryKey(id);
        DataLimitRuleTmplRespDto dataLimitRuleTmplRespDto = new DataLimitRuleTmplRespDto();
        if (null != dataLimitRuleTmplEo) {
            DtoHelper.eo2Dto((BaseEo)dataLimitRuleTmplEo, (BaseVo)dataLimitRuleTmplRespDto);
            DataLimitRuleTmplFuncEo query = new DataLimitRuleTmplFuncEo();
            query.setTmplId(id);
            List funcEoList = this.dataLimitRuleTmplFuncDas.selectList((BaseEo)query);
            if (!CollectionUtils.isEmpty((Collection)funcEoList)) {
                ArrayList funcRespDtoList = new ArrayList();
                DtoHelper.eoList2DtoList((Collection)funcEoList, funcRespDtoList, DataLimitRuleTmplFuncRespDto.class);
                dataLimitRuleTmplRespDto.setFuncRespDtoList(funcRespDtoList);
            }
        }
        return dataLimitRuleTmplRespDto;
    }

    @Override
    public PageInfo<DataLimitRuleTmplRespDto> queryByPage(DataLimitRuleTmplReqDto reqDto, Integer pageNum, Integer pageSize) {
        DataLimitRuleTmplEo dataLimitRuleTmplEo = new DataLimitRuleTmplEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)dataLimitRuleTmplEo);
        dataLimitRuleTmplEo.setOrderBy("entity_code");
        PageInfo eoPageInfo = this.dataLimitRuleTmplDas.selectPage((BaseEo)dataLimitRuleTmplEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<DataLimitRuleTmplRespDto> dtoList = new ArrayList<DataLimitRuleTmplRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DataLimitRuleTmplRespDto.class);
        if (!CollectionUtils.isEmpty(dtoList)) {
            this.assembleFunc(dtoList);
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private void assembleFunc(List<DataLimitRuleTmplRespDto> dtoList) {
        List tmpIdList = dtoList.stream().map(DataLimitRuleTmplRespDto::getId).collect(Collectors.toList());
        ArrayList<SqlFilter> filterList = new ArrayList<SqlFilter>();
        SqlFilter sqlFilter = new SqlFilter();
        sqlFilter.setProperty("tmpl_id");
        sqlFilter.setOperator(SqlFilter.Operator.in);
        sqlFilter.setValue(tmpIdList);
        filterList.add(sqlFilter);
        DataLimitRuleTmplFuncEo funcEo = new DataLimitRuleTmplFuncEo();
        funcEo.setSqlFilters(filterList);
        List funcEoList = this.dataLimitRuleTmplFuncDas.select((BaseEo)funcEo, Integer.valueOf(1), Integer.valueOf(1000));
        ArrayList funcRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)funcEoList, funcRespDtoList, DataLimitRuleTmplFuncRespDto.class);
        Map<Long, List<DataLimitRuleTmplFuncRespDto>> funcMap = funcRespDtoList.stream().collect(Collectors.groupingBy(DataLimitRuleTmplFuncRespDto::getTmplId));
        for (DataLimitRuleTmplRespDto dataLimitRuleTmplRespDto : dtoList) {
            dataLimitRuleTmplRespDto.setFuncRespDtoList(funcMap.get(dataLimitRuleTmplRespDto.getId()));
        }
    }

    @Override
    public StringBuilder handleConfigGroups(List<ExpressionConfigGroupDto> expressionConfigGroups, DataLimitRuleEo ruleEo, List<RuleTmplVarVo> tmplVarEoList, boolean refConfig) {
        StringBuilder expression = new StringBuilder();
        for (ExpressionConfigGroupDto expressionConfigGroup : expressionConfigGroups) {
            StringBuilder configsExpression;
            List expressionConfigs = expressionConfigGroup.getExpressionConfigs();
            Assert.notEmpty((Collection)expressionConfigs, (String)"\u6570\u636e\u6743\u9650\u914d\u7f6e\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            if (expression.toString().length() > 0) {
                expression.append(" ").append(RelationalOperatorEnum.AND.getCode()).append(" ");
            }
            String entityCode = ruleEo.getEntityCode();
            if (refConfig) {
                entityCode = expressionConfigGroup.getRefEntityCode();
                Assert.hasText((String)entityCode, (String)"\u5f15\u7528\u5b9e\u4f53\u7f16\u7801\uff0c\u5f53\u8bbe\u7f6e\u5173\u8054\u8868\u5176\u4ed6\u6761\u4ef6\u65f6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StringUtils.isNotEmpty((CharSequence)(configsExpression = this.handleConfigs(expressionConfigs, ruleEo, tmplVarEoList, entityCode)))) continue;
            if (!refConfig) {
                expression.append("[");
            }
            expression.append((CharSequence)configsExpression);
            if (refConfig) {
                expression.append(" ").append("JOIN_END");
                continue;
            }
            expression.append("]");
        }
        return expression;
    }

    private StringBuilder handleConfigs(List<ExpressionConfigDto> expressionConfigs, DataLimitRuleEo ruleEo, List<RuleTmplVarVo> tmplVarEoList, String entityCode) {
        StringBuilder configsExpression = new StringBuilder();
        for (ExpressionConfigDto expressionConfig : expressionConfigs) {
            String dataType;
            boolean valueIsNull;
            this.expressionConfigCheck(expressionConfig);
            boolean bl = valueIsNull = CollectionUtils.isEmpty((Collection)expressionConfig.getAttrCodes()) && StringUtils.isEmpty((CharSequence)expressionConfig.getDefaultValue()) && null == expressionConfig.getFunc() && CollectionUtils.isEmpty((Collection)expressionConfig.getChildren());
            if (valueIsNull) continue;
            String logicalOperator = expressionConfig.getLogicalOperator().toUpperCase();
            Integer valueType = expressionConfig.getValueType();
            String value = null;
            String string = dataType = expressionConfig.getDataType() == null ? "" : expressionConfig.getDataType();
            if (configsExpression.length() > 0) {
                configsExpression.append(" ").append(RelationalOperatorEnum.OR.getCode()).append(" ");
            }
            if (ValueTypeEnum.ASSOCIATIVE_TABLE.getType().equals(valueType)) {
                configsExpression.append("JOIN_START").append(" ");
            }
            configsExpression.append(entityCode).append(".").append(expressionConfig.getFieldCode()).append(" ").append(logicalOperator).append(" ");
            switch (valueType) {
                case 1: {
                    if (CollectionUtils.isNotEmpty((Collection)expressionConfig.getAttrCodes())) {
                        List attrCodes = expressionConfig.getAttrCodes();
                        if (!DataLimitConstant.NUMBER_SYMBOL.contains(dataType)) {
                            attrCodes = attrCodes.stream().map(code -> DataLimitStringUtil.getStringValue(code)).collect(Collectors.toList());
                        }
                        value = DataLimitStringUtil.getSystemValue(StringUtils.join((Iterable)attrCodes, (String)","));
                        break;
                    }
                    value = this.handleValue(expressionConfig, ValueTypeEnum.SYSTEM_DEFAULT.getType());
                    break;
                }
                case 2: {
                    if (StringUtils.isNotEmpty((CharSequence)expressionConfig.getDefaultValue())) {
                        String defaultValue = expressionConfig.getDefaultValue();
                        if (!DataLimitConstant.NUMBER_SYMBOL.contains(dataType)) {
                            defaultValue = DataLimitStringUtil.getStringValue(expressionConfig.getDefaultValue());
                        }
                        value = defaultValue;
                        break;
                    }
                    value = this.handleValue(expressionConfig, ValueTypeEnum.MANUAL.getType());
                    break;
                }
                case 3: {
                    FuncReqDto func = expressionConfig.getFunc();
                    Assert.notNull((Object)func, (String)String.format("\u5b57\u6bb5\u7f16\u7801\uff1a%s,\u51fd\u6570\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01", expressionConfig.getFieldCode()));
                    Assert.hasText((String)func.getBeanName(), (String)"\u51fd\u6570beanName\u4e0d\u80fd\u4e3a\u7a7a");
                    Assert.hasText((String)func.getFuncName(), (String)"\u51fd\u6570\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    value = func.getBeanName() + "." + func.getFuncName() + "(";
                    value = this.handleFuncValue(ruleEo, value, func);
                    value = value + ")";
                    value = DataLimitStringUtil.getFunValue(value);
                    break;
                }
                case 4: {
                    List children = expressionConfig.getChildren();
                    Assert.notEmpty((Collection)children, (String)String.format("\u5b57\u6bb5\u7f16\u7801\uff1a%s,\u5173\u8054\u8868\u5176\u4ed6\u6761\u4ef6\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01", expressionConfig.getFieldCode()));
                    value = this.handleConfigGroups(children, ruleEo, tmplVarEoList, true).toString();
                    break;
                }
            }
            logger.info("\u8868\u8fbe\u5f0f\u503c\u4e3a{}", value);
            configsExpression.append(value);
        }
        logger.info("\u903b\u8f91\u914d\u7f6e\u5206\u7ec4\u6761\u4ef6\u914d\u7f6e\u8868\u8fbe\u5f0f\u4e3a{}", (Object)configsExpression.toString());
        return configsExpression;
    }

    private String handleFuncValue(DataLimitRuleEo ruleEo, String value, FuncReqDto func) {
        List paramList = func.getRequestParams();
        if (CollectionUtils.isNotEmpty((Collection)paramList)) {
            for (FuncReqDto.Param param : paramList) {
                Assert.hasText((String)param.getName(), (String)"\u53c2\u6570\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.hasText((String)param.getType(), (String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                if (ruleEo.getId() != null) {
                    Assert.hasText((String)param.getValue(), (String)"\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isNotEmpty((CharSequence)param.getValue())) {
                    String paramValue = param.getValue();
                    if (!DataLimitConstant.NUMBER_SYMBOL.contains(param.getType())) {
                        paramValue = DataLimitStringUtil.getStringValue(paramValue);
                    }
                    value = value + paramValue + ",";
                    continue;
                }
                value = value + String.format("#{%s}", param.getName()) + ",";
            }
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private void expressionConfigCheck(ExpressionConfigDto expressionConfig) {
        Assert.hasText((String)expressionConfig.getFieldCode(), (String)"\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)expressionConfig.getLogicalOperator(), (String)"\u903b\u8f91\u8fd0\u7b97\u7b26\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)expressionConfig.getValueType(), (String)"\u53d6\u503c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)LogicalOperatorEnum.getDescByCode((String)expressionConfig.getLogicalOperator()), (String)"\u903b\u8f91\u8fd0\u7b97\u7b26\u4e0d\u652f\u6301\uff01");
        Assert.notNull((Object)ValueTypeEnum.getDescByType((Integer)expressionConfig.getValueType()), (String)"\u53d6\u503c\u7c7b\u578b\u4e0d\u652f\u6301\uff01");
    }

    private String handleValue(ExpressionConfigDto expressionConfig, Integer valueType) {
        return String.format("#{%s}", expressionConfig.getFieldCode());
    }

    @Override
    public List<ExpressionConfigGroupDto> getConfigGroups(String expression, boolean refConfig, Long ruleId) {
        List<String> expressionGroupList;
        ArrayList expressionConfigGroups = Lists.newArrayList();
        if (!StringUtils.isEmpty((CharSequence)expression) && CollectionUtils.isNotEmpty(expressionGroupList = RegexUtil.getExpressionGroupList(expression = DataLimitStringUtil.replaceCharSymbol(expression)))) {
            for (String expressionGroup : expressionGroupList) {
                if (StringUtils.isEmpty((CharSequence)expressionGroup)) continue;
                ExpressionConfigGroupDto configGroup = new ExpressionConfigGroupDto();
                String refEntityCode = expressionGroup.substring(0, expression.indexOf(".") - 1);
                configGroup.setRefEntityCode(refEntityCode.replaceAll("JOIN_START", "").trim());
                configGroup.setRelationalOperator(RelationalOperatorEnum.AND.getCode());
                List<ExpressionConfigDto> expressionConfigs = this.getConfigs(expressionGroup, ruleId);
                configGroup.setExpressionConfigs(expressionConfigs);
                expressionConfigGroups.add(configGroup);
            }
        }
        return expressionConfigGroups;
    }

    private List<ExpressionConfigDto> getConfigs(String expressionGroup, Long ruleId) {
        List<String> configList;
        ArrayList expressionConfigs = Lists.newArrayList();
        ArrayList expressionRefConfigs = Lists.newArrayList();
        List<String> refList = RegexUtil.getRefList(expressionGroup);
        if (CollectionUtils.isNotEmpty(refList)) {
            for (String ref : refList) {
                expressionGroup = expressionGroup.equals("JOIN_START" + ref + "JOIN_END") ? "" : expressionGroup.replaceAll("JOIN_START" + DataLimitStringUtil.escape(ref) + "JOIN_END", "");
                ExpressionConfigDto configDto = this.getRefConfig(ref.trim(), ruleId);
                if (configDto == null) continue;
                expressionRefConfigs.add(configDto);
            }
        }
        if (CollectionUtils.isNotEmpty(configList = Arrays.asList(expressionGroup.split(RelationalOperatorEnum.OR.getCode())))) {
            for (String config : configList) {
                ExpressionConfigDto configDto = this.getConfig(config.trim(), ruleId);
                if (configDto == null) continue;
                expressionConfigs.add(configDto);
            }
        }
        expressionConfigs.addAll(expressionRefConfigs);
        return expressionConfigs;
    }

    private ExpressionConfigDto getRefConfig(String ref, Long ruleId) {
        ExpressionConfigDto configDto = null;
        if (!StringUtils.isEmpty((CharSequence)ref)) {
            ref = ref.trim();
            configDto = new ExpressionConfigDto();
            configDto.setFieldCode(this.getFieldCode(ref));
            configDto.setLogicalOperator(this.getLogicalOperator(ref));
            configDto.setValueType(ValueTypeEnum.ASSOCIATIVE_TABLE.getType());
            String expression = this.getDefaultValue(ref);
            configDto.setChildren(this.getConfigGroups("[" + expression + "]", true, ruleId));
        }
        return configDto;
    }

    private String getDefaultValue(String ref) {
        return ref.substring(ref.indexOf(" ", ref.indexOf(" ") + 1) + 1);
    }

    private String getLogicalOperator(String ref) {
        return ref.substring(ref.indexOf(" ") + 1, ref.indexOf(" ", ref.indexOf(" ") + 1));
    }

    private String getFieldCode(String ref) {
        return ref.substring(ref.indexOf(".") + 1, ref.indexOf(" "));
    }

    private ExpressionConfigDto getConfig(String config, Long ruleId) {
        ExpressionConfigDto configDto = null;
        if (!StringUtils.isEmpty((CharSequence)config)) {
            config = config.trim();
            config = config.replace(LogicalOperatorEnum.NOTIN.getCode(), "NOTIN");
            configDto = new ExpressionConfigDto();
            configDto.setFieldCode(this.getFieldCode(config));
            String logicalOperator = this.getLogicalOperator(config).replace("NOTIN", LogicalOperatorEnum.NOTIN.getCode());
            configDto.setLogicalOperator(logicalOperator);
            String defaultValue = this.getDefaultValue(config);
            List<String> varCodeList = RegexUtil.getVarCodeList(defaultValue);
            if (defaultValue.contains("FUN_START")) {
                configDto.setValueType(ValueTypeEnum.FUNCTION.getType());
                FuncReqDto funcReqDto = this.getFuncReqDto(ruleId, defaultValue);
                configDto.setFunc(funcReqDto);
            } else if (CollectionUtils.isNotEmpty(varCodeList)) {
                configDto.setDefaultValue(null);
                String varCode = varCodeList.get(0);
                configDto.setValueType(ValueTypeEnum.MANUAL.getType());
            } else if (defaultValue.contains("SYSTEM_START")) {
                configDto.setValueType(ValueTypeEnum.SYSTEM_DEFAULT.getType());
                configDto.setAttrCodes(Arrays.asList(DataLimitStringUtil.replaceSystemSymbol(defaultValue).split(",")));
                configDto.setDefaultValue(DataLimitStringUtil.replaceSystemSymbol(defaultValue));
            } else {
                configDto.setValueType(ValueTypeEnum.MANUAL.getType());
                configDto.setDefaultValue(defaultValue);
            }
        }
        if (configDto != null && StringUtils.isEmpty((CharSequence)configDto.getFieldCode())) {
            configDto = null;
        }
        return configDto;
    }

    private FuncReqDto getFuncReqDto(Long ruleId, String defaultValue) {
        Assert.notNull((Object)ruleId, (String)"\u89c4\u5219id\u4e3a\u7a7a");
        FuncReqDto funcReqDto = new FuncReqDto();
        defaultValue = DataLimitStringUtil.replaceSymbol(defaultValue);
        defaultValue = defaultValue.trim();
        String beanName = defaultValue.substring(0, defaultValue.lastIndexOf("."));
        String funcName = defaultValue.substring(defaultValue.lastIndexOf(".") + 1, defaultValue.indexOf("("));
        funcReqDto.setBeanName(beanName);
        funcReqDto.setFuncName(funcName);
        ArrayList requestParams = Lists.newArrayList();
        ArrayList varVoList = Lists.newArrayList();
        List varEoList = this.dataLimitRuleVarDas.selectByApiCode(ruleId, beanName + "." + funcName);
        CubeBeanUtils.copyCollection((Collection)varVoList, (Collection)varEoList, VarVo.class);
        if (CollectionUtils.isNotEmpty((Collection)varVoList)) {
            for (VarVo varVo : varVoList) {
                FuncReqDto.Param param = new FuncReqDto.Param();
                param.setName(varVo.getVarCode());
                String varValue = varVo.getVarValue();
                if (StringUtils.isNotEmpty((CharSequence)varValue)) {
                    varValue = DataLimitStringUtil.replaceCharSymbol(varValue);
                }
                param.setValue(varValue);
                requestParams.add(param);
            }
        }
        funcReqDto.setRequestParams((List)requestParams);
        return funcReqDto;
    }
}

