/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.HurdleDefinitionDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.HurdleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.HurdleInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.HurdleDefinitionVo;
import com.dtyunxi.yundt.cube.center.user.biz.service.IHurdleDefinitionService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.HurdleDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.HurdleDefinitionDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.HurdleInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserRoleRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.HurdleDefinitionEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.HurdleEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.HurdleInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserRoleRelationEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HurdleDefinitionServiceImpl
implements IHurdleDefinitionService {
    @Autowired
    IUserService userService;
    @Autowired
    HurdleDefinitionDas hurdleDefinitionDas;
    @Autowired
    HurdleDas hurdleDas;
    @Autowired
    HurdleInfoDas hurdleInfoDas;
    @Autowired
    UserRoleRelationDas userRoleRelationDas;

    @Override
    public List<HurdleDefinitionVo> queryHurdleDefinitions(Long userId) {
        List hurdleDefinitionEos;
        if (this.isTenantAdmin(userId)) {
            hurdleDefinitionEos = this.hurdleDefinitionDas.selectAll();
        } else {
            List<Long> appIds = this.userService.queryUserAuthInstanceList(userId);
            if (appIds.isEmpty()) {
                return Collections.emptyList();
            }
            hurdleDefinitionEos = this.hurdleDefinitionDas.selectByWebInstanceList(appIds);
        }
        List<HurdleDefinitionVo> result = hurdleDefinitionEos.stream().map(hurdleDefinitionEo -> {
            HurdleDefinitionVo resultVo = new HurdleDefinitionVo();
            HurdleDefinitionDto hurdleDefinitionDto = new HurdleDefinitionDto();
            DtoHelper.eo2Dto((BaseEo)hurdleDefinitionEo, (BaseVo)hurdleDefinitionDto);
            resultVo.setHurdleDefinitionDto(hurdleDefinitionDto);
            String code = hurdleDefinitionDto.getHurdleCode();
            HurdleEo hurdleEo = new HurdleEo();
            hurdleEo.setCode(code);
            hurdleEo = (HurdleEo)this.hurdleDas.selectOne((BaseEo)hurdleEo);
            HurdleDto hurdleDto = new HurdleDto();
            DtoHelper.eo2Dto((BaseEo)hurdleEo, (BaseVo)hurdleDto);
            resultVo.setHurdleDto(hurdleDto);
            HurdleInfoEo hurdleInfoEo = new HurdleInfoEo();
            hurdleInfoEo.setHurdleCode(code);
            List hurdleInfoEos = this.hurdleInfoDas.select((BaseEo)hurdleInfoEo);
            ArrayList list = new ArrayList(hurdleInfoEos.size());
            DtoHelper.eoList2DtoList((Collection)hurdleInfoEos, list, HurdleInfoDto.class);
            resultVo.setHurdleInfoDtos(list);
            return resultVo;
        }).collect(Collectors.toList());
        return result;
    }

    @Override
    public List<HurdleInfoDto> queryHurdleInfoByHurdleCode(String code) {
        HurdleInfoEo eo = new HurdleInfoEo();
        eo.setHurdleCode(code);
        List hurdleInfoEos = this.hurdleInfoDas.select((BaseEo)eo);
        ArrayList<HurdleInfoDto> list = new ArrayList<HurdleInfoDto>(hurdleInfoEos.size());
        DtoHelper.eoList2DtoList((Collection)hurdleInfoEos, list, HurdleInfoDto.class);
        return list;
    }

    @Override
    public void addHurdleDefinition(HurdleDefinitionDto hurdleDefinitionDto) {
        AssertUtil.isTrue(hurdleDefinitionDto != null, "\u53c2\u6570\u5f02\u5e38\uff01");
        HurdleDefinitionEo eo = new HurdleDefinitionEo();
        eo.setName(hurdleDefinitionDto.getName());
        AssertUtil.isTrue(this.hurdleDefinitionDas.selectOne((BaseEo)eo) == null, "\u901a\u77e5\u680f\u540d\u79f0\u4e0d\u53ef\u91cd\u590d");
        DtoHelper.dto2Eo((BaseVo)hurdleDefinitionDto, (BaseEo)eo);
        this.hurdleDefinitionDas.insert((BaseEo)eo);
    }

    @Override
    public void updateHurdleDefinition(Long id, HurdleDefinitionDto hurdleDefinitionDto) {
        AssertUtil.isTrue(id != null, "id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isTrue(this.hurdleDefinitionDas.selectByPrimaryKey(id) != null, "\u680f\u4f4d\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728");
        HurdleDefinitionEo eo = new HurdleDefinitionEo();
        DtoHelper.dto2Eo((BaseVo)hurdleDefinitionDto, (BaseEo)eo);
        eo.setId(id);
        this.hurdleDefinitionDas.update((BaseEo)eo);
    }

    @Override
    public void deleteHurdleDefinition(Long id) {
        AssertUtil.isTrue(id != null, "id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.hurdleDefinitionDas.deleteById(id);
    }

    @Override
    public PageInfo<HurdleDto> queryPage(String type, Integer pageNum, Integer pageSize) {
        HurdleEo hurdleEo = new HurdleEo();
        hurdleEo.setType(type);
        PageInfo hurdleEoPageInfo = this.hurdleDas.selectPage((BaseEo)hurdleEo, pageNum, pageSize);
        return QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)hurdleEoPageInfo, HurdleDto.class);
    }

    @Override
    public List<HurdleDto> queryHurdleType() {
        List hurdleEos = this.hurdleDas.queryType();
        ArrayList<HurdleDto> list = new ArrayList<HurdleDto>();
        DtoHelper.eoList2DtoList((Collection)hurdleEos, list, HurdleDto.class);
        return list;
    }

    private boolean isTenantAdmin(Long userId) {
        UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
        userRoleRelationEo.setUserId(userId);
        userRoleRelationEo.setRoleCode("TENANT_ADMIN");
        return this.userRoleRelationDas.selectOne((BaseEo)userRoleRelationEo) != null;
    }
}

