/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.limit.dao.das;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.RuleTypeEnum;
import com.dtyunxi.yundt.cube.center.data.limit.api.exception.DataLimitExceptionCode;
import com.dtyunxi.yundt.cube.center.data.limit.dao.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.DataLimitRuleEo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.StdDataLimitRuleEo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DataLimitRuleDas
extends AbstractBaseDas<DataLimitRuleEo, String> {
    private LambdaQueryWrapper<DataLimitRuleEo> getBaseQueryWrapper() {
        return (LambdaQueryWrapper)Wrappers.lambdaQuery(DataLimitRuleEo.class).eq(BaseEo::getDr, (Object)0);
    }

    public int count(Set<Long> ruleIdList, List<String> entityCodeList, Integer ruleType) {
        DataLimitRuleEo eo = this.getDataLimitRuleEo(ruleIdList, entityCodeList, ruleType, null);
        eo.getSqlFilters().add(SqlFilter.ne((String)"expression", (Object)"[]"));
        return this.count((BaseEo)eo);
    }

    public List<DataLimitRuleEo> select(Set<Long> ruleIdList, List<String> entityCodeList, Integer ruleType) {
        DataLimitRuleEo eo = this.getDataLimitRuleEo(ruleIdList, entityCodeList, ruleType, null);
        return this.select((BaseEo)eo);
    }

    public List<DataLimitRuleEo> select(Set<Long> ruleIdList, List<String> entityCodeList, Integer ruleType, Integer status) {
        DataLimitRuleEo eo = this.getDataLimitRuleEo(ruleIdList, entityCodeList, ruleType, status);
        return this.select((BaseEo)eo);
    }

    private DataLimitRuleEo getDataLimitRuleEo(Set<Long> ruleIdList, List<String> entityCodeList, Integer ruleType, Integer status) {
        DataLimitRuleEo eo = new DataLimitRuleEo();
        eo.setRuleType(ruleType);
        eo.setStatus(status);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (CollectionUtils.isNotEmpty(ruleIdList)) {
            sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ruleIdList, (String)",")));
        }
        if (CollectionUtils.isNotEmpty(entityCodeList)) {
            sqlFilters.add(SqlFilter.in((String)"entity_code", (Object)StringUtils.join(entityCodeList, (String)",")));
        }
        eo.setSqlFilters(sqlFilters);
        return eo;
    }

    public int countByCodeAndRuleType(String code, Long instanceId, Integer ruleType) {
        DataLimitRuleEo ruleEo = new DataLimitRuleEo();
        ruleEo.setCode(code);
        ruleEo.setInstanceId(instanceId);
        ruleEo.setRuleType(ruleType);
        return this.count((BaseEo)ruleEo);
    }

    public List<DataLimitRuleEo> selectByEntityCode(String domainCode, String entityCode) {
        DataLimitRuleEo ruleEo = new DataLimitRuleEo();
        ruleEo.setEntityCode(entityCode);
        ruleEo.setDomainCode(domainCode);
        return this.select((BaseEo)ruleEo, 1, 1000);
    }

    public DataLimitRuleEo findByIdAndRuleType(Long id, RuleTypeEnum typeEnum) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DataLimitRuleEo.class).eq(BaseEo::getId, (Object)id)).eq(StdDataLimitRuleEo::getRuleType, (Object)typeEnum.getType())).eq(BaseEo::getDr, (Object)0);
        return (DataLimitRuleEo)this.getOne((Wrapper)wrapper);
    }

    public DataLimitRuleEo findByIdAndRuleTypeOrElseThrow(Long id, RuleTypeEnum typeEnum) {
        return Optional.ofNullable(this.findByIdAndRuleType(id, typeEnum)).orElseThrow(() -> ((DataLimitExceptionCode)DataLimitExceptionCode.DATA_LIMIT_RULE_NOT_EXIST).buildBizException());
    }

    public DataLimitRuleEo findByCodeAndRuleType(String code, RuleTypeEnum typeEnum) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)this.getBaseQueryWrapper().eq(StdDataLimitRuleEo::getCode, (Object)code)).eq(StdDataLimitRuleEo::getRuleType, (Object)typeEnum.getType())).eq(BaseEo::getDr, (Object)0);
        return (DataLimitRuleEo)this.getOne((Wrapper)wrapper);
    }
}

