ALTER TABLE `us_data_limit_rule` MODIFY COLUMN `rule_tmpl_code`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '规则模板编码' AFTER `id`;

ALTER TABLE `us_data_limit_rule` MODIFY COLUMN `name`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '规则名称' AFTER `rule_tmpl_code`;

ALTER TABLE `us_data_limit_rule` MODIFY COLUMN `code`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '规则编码' AFTER `name`;

ALTER TABLE `us_data_limit_rule` MODIFY COLUMN `domain_code`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '领域编码' AFTER `code`;

ALTER TABLE `us_data_limit_rule` MODIFY COLUMN `entity_code`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '实体编码' AFTER `domain_code`;

ALTER TABLE `us_data_limit_rule` MODIFY COLUMN `entity_name`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '实体名称' AFTER `entity_code`;

ALTER TABLE `us_data_limit_rule_tmpl` DROP INDEX `idx_code`;

ALTER TABLE `us_data_limit_rule_tmpl` ADD COLUMN `domain_name`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '领域名称' AFTER `domain_code`;

ALTER TABLE `us_data_limit_rule_tmpl` ADD COLUMN `entity_alias`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '实体显示名称' AFTER `entity_name`;

ALTER TABLE `us_data_limit_rule_tmpl` ADD COLUMN `field_code`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '字段编码' AFTER `entity_alias`;

ALTER TABLE `us_data_limit_rule_tmpl` ADD COLUMN `field_alias`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '字段显示名称' AFTER `field_code`;

ALTER TABLE `us_data_limit_rule_tmpl` ADD COLUMN `field_name`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '字段名称。默认采用字段名称，用户可自定义' AFTER `field_alias`;

ALTER TABLE `us_data_limit_rule_tmpl` ADD COLUMN `use_sys_val`  tinyint(2) NOT NULL DEFAULT 0 COMMENT '受控字段值是否来源于系统选项， 0否，1是' AFTER `field_name`;

ALTER TABLE `us_data_limit_rule_tmpl` ADD COLUMN `use_user_input`  tinyint(2) NOT NULL DEFAULT 0 COMMENT '受控字段的值是否来源于用户输入，0否，1是' AFTER `use_sys_val`;

ALTER TABLE `us_data_limit_rule_tmpl` ADD COLUMN `use_func`  tinyint(2) NOT NULL DEFAULT 0 COMMENT '受控字段值是否来源于函数，0否，1是' AFTER `use_user_input`;

ALTER TABLE `us_data_limit_rule_tmpl` ADD COLUMN `ref_app_inst_id`  bigint(20) NOT NULL COMMENT '关联应用实例id' AFTER `use_func`;

ALTER TABLE `us_data_limit_rule_tmpl` ADD COLUMN `limit_way`  tinyint(2) NULL DEFAULT NULL COMMENT '限制方式，1完全隐藏，2脱敏' AFTER `ref_app_inst_id`;

ALTER TABLE `us_data_limit_rule_tmpl` ADD COLUMN `tmpl_type`  tinyint(2) NULL DEFAULT 1 COMMENT '模板类型，规则模板类型，1数据权限(行)，2字段权限(列)' AFTER `limit_way`;

ALTER TABLE `us_data_limit_rule_tmpl` MODIFY COLUMN `id`  bigint(20) NOT NULL COMMENT '主键' FIRST ;

ALTER TABLE `us_data_limit_rule_tmpl` MODIFY COLUMN `code`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '模板编码' AFTER `id`;

ALTER TABLE `us_data_limit_rule_tmpl` MODIFY COLUMN `domain_code`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '领域编码' AFTER `code`;

ALTER TABLE `us_data_limit_rule_tmpl` MODIFY COLUMN `entity_code`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '实体编码' AFTER `domain_name`;

ALTER TABLE `us_data_limit_rule_tmpl` MODIFY COLUMN `entity_name`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '实体名称，默认采用实体名称，用户可自定义' AFTER `entity_code`;

ALTER TABLE `us_data_limit_rule_tmpl` DROP PRIMARY KEY;

ALTER TABLE `us_data_limit_rule_tmpl` DROP COLUMN `name`;

ALTER TABLE `us_data_limit_rule_tmpl` DROP COLUMN `expression`;

ALTER TABLE `us_data_limit_rule_tmpl` DROP COLUMN `actions`;

ALTER TABLE `us_data_limit_rule_tmpl` DROP COLUMN `visible_fields`;

ALTER TABLE `us_data_limit_rule_tmpl` DROP COLUMN `version`;

ALTER TABLE `us_data_limit_rule_tmpl` DROP COLUMN `status`;

ALTER TABLE `us_data_limit_rule_var` MODIFY COLUMN `var_value`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '变量的值' AFTER `var_code`;

ALTER TABLE `us_field_limit_detail` ADD COLUMN `alias`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '显示名称' AFTER `name`;

CREATE TABLE IF NOT EXISTS `us_data_limit_rule_tmpl_func` (
  `id` bigint(20) NOT NULL COMMENT '主键',
  `tmpl_id` bigint(20) NOT NULL COMMENT '关联规则模板id',
  `bean_name` varchar(255) NOT NULL COMMENT 'bean名称',
  `func_name` varchar(255) NOT NULL COMMENT '数据权限函数名称',
  `func_desc` varchar(255) NOT NULL COMMENT '接口描述',
  `extension` varchar(255) DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) DEFAULT '0' COMMENT '应用实例ID',
  `tenant_id` bigint(20) DEFAULT '0' COMMENT '租户ID',
  `dr` tinyint(2) DEFAULT NULL COMMENT '逻辑删除标记',
  `create_person` varchar(50) DEFAULT '' COMMENT '创建人',
  `create_time` datetime DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50) DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`),
  KEY `idx_tmpl_id` (`tmpl_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='数据权限模板关联的函数';



