/**
 * @(#)IAreaApi.java 1.0 2018/8/20
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.data.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;


/**
 * 区域信息 API接口
 *
 * @author 华生
 * @since 1.0.0
 */
@Api(tags = {"基础数据中心：区域数据管理：区域信息服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-data-api-IAreaApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", url = "${yundt.cube.center.data.api:}")
public interface IAreaApi {

    /**
     * 新增区域方法
     *
     * @param areaDto 新增区域实体
     * @return Long 数据保存后的ID
     */
    @PostMapping("/v2/area")
    @ApiOperation(value = "新增区域", notes = "新增区域")
    @Capability(capabilityCode = "basicdata.area.save-area")
    RestResponse<Long> saveArea(AreaDto areaDto);

    /**
     * 通过ID删除区域方法
     *
     * @param areaId 区域ID
     * @return RestResponse&lt;Void&gt;
     */
    @DeleteMapping(value = "/v2/area/{areaId}")
    @ApiOperation(value = "删除区域", notes = "根据区域ID删除数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaId", value = "区域ID", dataType = "Long", paramType = "path", required = true)

    })
    @Capability(capabilityCode = "basicdata.area.remove-by-id")
    RestResponse<Void> removeById(@PathVariable("areaId") Long areaId);

    /**
     * 修改区域方法
     *
     * @param areaDto 修改区域实体
     * @return RestResponse&lt;Void&gt;
     */
    @PutMapping("/v2/area")
    @ApiOperation(value = "修改区域", notes = "修改区域")
    @Capability(capabilityCode = "basicdata.area.modify-area")
    RestResponse<Void> modifyArea(AreaDto areaDto);

    /**
     * 同步区域信息
     *
     * @return 操作结果
     */
    @PostMapping("/v2/area/sync")
    @ApiOperation(value = "同步区域信息", notes = "同步区域信息")
    @Capability(capabilityCode = "basicdata.area.sync")
    RestResponse<Void> sync();
}
