/*
 * @(#)IAreaComparisionApi.java 1.0 2018/8/20
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.data.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaComparisionDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;


/**
 * 区域对照信息 API接口
 *
 * @author 华生
 * @since 1.0.0
 */
@Api(tags = {"基础数据中心：区域数据管理：区域对照服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-data-api-IAreaComparisionApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", url = "${yundt.cube.center.data.api:}")
public interface IAreaComparisionApi {

    /**
     * 新增区域对照信息
     *
     * @param areaComparisionDto 新增区域对照实体
     * @return Long 数据保存后的ID
     */
    @PostMapping({"/v2/area-comparision", "/v3/area-comparision"})
    @ApiOperation(value = "新增区域对照信息", notes = "新增区域对照信息")
    @Capability(capabilityCode = "basicdata.area-comparision.save-area-comparision")
    RestResponse<Long> saveAreaComparision( AreaComparisionDto areaComparisionDto);

    /**
     * 通过ID删除区域对照信息
     *
     * @param areaComparisionId 区域对照信息ID
     * @return RestResponse&lt;Void&gt;
     */
    @DeleteMapping({"/v2/area-comparision/{areaComparisionId}", "/v3/area-comparision/{areaComparisionId}"})
    @ApiOperation(value = "删除区域对照信息", notes = "根据区域ID删除区域对照信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaComparisionId", value = "区域对照ID", dataType = "Long", paramType = "path", required = true)

    })
    @Capability(capabilityCode = "basicdata.area-comparision.remove-by-id")
    RestResponse<Void> removeById(@PathVariable("areaComparisionId") Long areaComparisionId);

    /**
     * 修改区域对照信息
     *
     * @param areaComparisionDto 修改区域对照信息实体
     * @return RestResponse&lt;Void&gt;
     */
    @PutMapping({"/v2/area-comparision", "/v3/area-comparision"})
    @ApiOperation(value = "修改区域对照信息", notes = "修改区域对照信息")
    @Capability(capabilityCode = "basicdata.area-comparision.modify-area-comparision")
    RestResponse<Void> modifyAreaComparision(AreaComparisionDto areaComparisionDto);

}
