/*
 * @(#)IDictApi.java1.0 2018年7月17日
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


package com.dtyunxi.yundt.cube.center.data.api;


import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * Dict  字典数据服务API接口
 *
 * @author 古奇
 * @since 1.0.0
 */
@Api(tags = {"基础数据中心：区域数据管理：字典项数据服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-data-api-IDictApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", url = "${yundt.cube.center.data.api:}")
public interface IDictApi {

    /**
     * 新增字典
     *
     * @param dictDto 字典
     * @return RestResponse&lt;Void&gt;
     */
    @RequestMapping(value = {"/v2/dict", "/v3/dict-entry"}, method = RequestMethod.POST)
    @ApiOperation(value = "新增字典", notes = "新增字典")
    @Capability(capabilityCode = "basicdata.dict.save-dict")
    RestResponse<Void> saveDict(@Validated @RequestBody DictDto dictDto);

    /**
     * 删除字典(根据租户Id,分组和code)
     *
     * @param tenantId  租户Id
     * @param groupCode 分组
     * @param code      枚举key
     * @return RestResponse&lt;Void&gt;
     */
    @RequestMapping(value = {"/v2/dict/{tenantId}/{groupCode}/{code}", "/v3/dict/{tenantId}/{groupCode}/{code}"}, method = RequestMethod.DELETE)
    @ApiOperation(value = "删除字典", notes = "根据分组和code删除数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tenantId", value = "租户id", dataType = "long", paramType = "path", required = true),
            @ApiImplicitParam(name = "groupCode", value = "分组", dataType = "string", paramType = "path", required = true),
            @ApiImplicitParam(name = "code", value = "枚举key", dataType = "string", paramType = "path", required = true),
    })
    @Capability(capabilityCode = "basicdata.dict.remove-dict")
    RestResponse<Void> removeDict(@PathVariable("tenantId") Long tenantId,
                                  @PathVariable("groupCode") String groupCode,
                                  @PathVariable("code") String code);

    /**
     * 修改字典(根据分组和code)
     *
     * @param dictDto 字典
     * @return RestResponse&lt;Void&gt;
     */
    @PutMapping(value = {"/v2/dict", "/v3/dict-entry"})
    @ApiOperation(value = "修改字典", notes = "根据字典分组和枚举key修改字典")
    @Capability(capabilityCode = "basicdata.dict.modify-dict")
    RestResponse<Void> modifyDict(@Validated @RequestBody DictDto dictDto);

}
