/*
 * @(#)AreaComparisionDto.java 1.0 2018/8/20
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.data.api.dto;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.Map;


/**
 * 区域信息对照Dto实体
 *
 * @author 华生
 * @since 1.0.0
 */
@ApiModel(value = "AreaComparisionDto", description = "区域信息比较Dto")
public class AreaComparisionDto extends BaseReqDto {

    private static final long serialVersionUID = -5324816712440464349L;

    @ApiModelProperty(value = "区域对照ID")
    private Long id;

    /**
     * 省份编码
     */
    @ApiModelProperty(value = "省份编码")
    @NotNull(message = "省份编码不能为空")
    private String provinceCode;

    /**
     * 城市编码
     */
    @ApiModelProperty(value = "城市编码")
    @NotNull(message = "城市编码不能为空")
    private String cityCode;

    /**
     * 区域编码
     */
    @ApiModelProperty(value = "区域编码")
    @NotNull(message = "区域编码不能为空")
    private String areaCode;

    /**
     * 省份名称
     */
    @ApiModelProperty(value = "省份名称")
    private String province;

    /**
     * 城市名称
     */
    @ApiModelProperty(value = "城市名称")
    private String city;

    /**
     * 区域名称
     */
    @ApiModelProperty(value = "区域名称")
    private String area;

    /**
     * 可以是名称也可以是编码，由上层业务决定
     */
    @ApiModelProperty(value = "第三方平台编码")
    @NotNull(message = "第三方平面编码不能为空")
    private String thirdPlanformCode;

    /**
     * 第三方省份名称
     */
    @ApiModelProperty(value = "第三方省份名称")
    @NotNull(message = "第三方省份不能为空")
    private String thirdProvince;

    /**
     * 第三方城市名称
     */
    @ApiModelProperty(value = "第三方城市名称")
    @NotNull(message = "第三方城市不能为空")
    private String thirdCity;

    /**
     * 第三方区域名称
     */
    @ApiModelProperty(value = "第三方区域名称")
    @NotNull(message = "第三方区域不能为空")
    private String thirdArea;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createPerson;

    /**
     * 更新人
     */
    @ApiModelProperty(value = "更新人")
    private String updatePerson;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "dr")
    private Integer dr;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getThirdPlanformCode() {
        return thirdPlanformCode;
    }

    public void setThirdPlanformCode(String thirdPlanformCode) {
        this.thirdPlanformCode = thirdPlanformCode;
    }

    public String getThirdProvince() {
        return thirdProvince;
    }

    public void setThirdProvince(String thirdProvince) {
        this.thirdProvince = thirdProvince;
    }

    public String getThirdCity() {
        return thirdCity;
    }

    public void setThirdCity(String thirdCity) {
        this.thirdCity = thirdCity;
    }

    public String getThirdArea() {
        return thirdArea;
    }

    public void setThirdArea(String thirdArea) {
        this.thirdArea = thirdArea;
    }


}
