/*
 * @(#)DictDto.java 1.0 2018/8/17
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.data.api.dto;

import com.dtyunxi.yundt.cube.center.data.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * DictDto   字典Dto
 *
 * @author 古奇
 * @since 1.0.0
 */
@ApiModel(value = "DictDto", description = "字典Dto")
public class DictDto extends BaseReqDto {

    private static final long serialVersionUID = -3537290529178125511L;

    @ApiModelProperty(value = "字典Id")
    private Long id;

    @ApiModelProperty(value = "分组")
    @NotNull(message = "字典分组不能为空")
    private String groupCode;

    @ApiModelProperty(value = "枚举key")
    @NotNull(message = "枚举key不能为空")
    private String code;

    @ApiModelProperty(value = "枚举值")
    @NotNull(message = "枚举值不能为空")
    private String value;

    @ApiModelProperty(value = "枚举描述")
    private String statement;

    @ApiModelProperty(value = "状态: 0,锁定（不可停用） 1,启用 2.停用")
    private Integer status;

    @ApiModelProperty(value = "自定义1")
    private String def1;

    @ApiModelProperty(value = "自定义2")
    private String def2;

    @ApiModelProperty(value = "自定义3")
    private String def3;

    @ApiModelProperty(value = "自定义4")
    private String def4;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "创建人")
    private String createPerson;

    @ApiModelProperty(value = "更新人")
    private String updatePerson;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "dr")
    private Integer dr;

    @ApiModelProperty(value = "枚举类型(sys系统配置 enum系统枚举),dictValueList为空时，type会自动判断为sys")
    private String type;

    @ApiModelProperty(value = "系统枚举的具体值，当该属性不为空时type会为enum")
    private List<DictValueDto> dictValueList;

    @ApiModelProperty(value = "查询条件(枚举值的状态，1启用 2停用)")
    private Integer dictValueStatus;

    public Long getId() { return id; }

    public void setId(Long id) { this.id = id; }

    public String getGroupCode() { return groupCode; }

    public void setGroupCode(String groupCode) { this.groupCode = groupCode; }

    public String getCode() { return code; }

    public void setCode(String code) { this.code = code; }

    public String getValue() { return value; }

    public void setValue(String value) { this.value = value; }

    public String getStatement() { return statement; }

    public void setStatement(String statement) { this.statement = statement; }

    public Integer getStatus() { return status; }

    public void setStatus(Integer status) { this.status = status; }

    public String getDef1() { return def1; }

    public void setDef1(String def1) { this.def1 = def1; }

    public String getDef2() { return def2; }

    public void setDef2(String def2) { this.def2 = def2; }

    public String getDef3() { return def3; }

    public void setDef3(String def3) { this.def3 = def3; }

    public String getDef4() { return def4; }

    public void setDef4(String def4) { this.def4 = def4; }

    public Date getCreateTime() { return createTime; }

    public void setCreateTime(Date createTime) { this.createTime = createTime; }

    public String getCreatePerson() { return createPerson; }

    public void setCreatePerson(String createPerson) { this.createPerson = createPerson; }

    public String getUpdatePerson() { return updatePerson; }

    public void setUpdatePerson(String updatePerson) { this.updatePerson = updatePerson; }

    public Date getUpdateTime() { return updateTime; }

    public void setUpdateTime(Date updateTime) { this.updateTime = updateTime; }

    public Integer getDr() { return dr; }

    public void setDr(Integer dr) { this.dr = dr; }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<DictValueDto> getDictValueList() {
        return dictValueList;
    }

    public void setDictValueList(List<DictValueDto> dictValueList) {
        this.dictValueList = dictValueList;
    }

    public Integer getDictValueStatus() {
        return dictValueStatus;
    }

    public void setDictValueStatus(Integer dictValueStatus) {
        this.dictValueStatus = dictValueStatus;
    }
}
