/*
 * @(#)IAreaQueryApi.java 1.0 2018/8/20
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.data.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaTreeRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 区域信息类查询API
 *
 * @author 华生
 * @since 1.0.0
 */

@Api(tags = {"基础数据中心：区域数据管理：区域信息查询服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-query-IAreaQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", url = "${yundt.cube.center.data.api:}")
public interface IAreaQueryApi {

    /**
     * 通过ID查找区域
     *
     * @param areaId 区域Id
     * @return AreaDto
     */
    @Deprecated
    @RequestMapping(value = {"/v2/area/{areaId}", "/v3/area/{areaId}"}, method = RequestMethod.GET)
    @ApiOperation(value = "根据区域ID查询区域", notes = "根据区域ID查询区域")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaId", value = "区域ID", dataType = "Long", paramType = "path", required = true)
    })
    @Capability(capabilityCode = "basicdata.area.query-area-by-key")
    RestResponse<AreaDto> queryAreaByKey(@PathVariable("areaId") Long areaId);


    /**
     * 分页查询列表
     *
     * @param areaQueryReqReqDto 区域查询请求Dto
     * @return PageInfo
     */
    @RequestMapping(value = {"/v2/area/list", "/v3/area"}, method = RequestMethod.GET)
    @ApiOperation(value = "分页查询区域", notes = "分页查询区域")
    @Capability(capabilityCode = "basicdata.area.query-by-page")
    RestResponse<PageInfo<AreaDto>> queryByPage(@SpringQueryMap AreaQueryReqDto areaQueryReqReqDto);

    /**
     * 通过编码查找区域
     *
     * @param code 区域编码
     * @return AreaDto
     */
    @RequestMapping(value = {"/v2/area/code/{code}", "/v3/area/by-code/{code}"}, method = RequestMethod.GET)
    @ApiOperation(value = "根据区域编码查询区域", notes = "根据区域编码查询区域")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "区域编码", dataType = "String", paramType = "path", required = true)
    })
    @Capability(capabilityCode = "basicdata.area.query-by-code")
    RestResponse<AreaDto> queryByCode(@PathVariable("code") String code);

    /**
     * 通过父编码查找区域
     *
     * @param parentCode 父编码
     * @return AreaDtoList
     */
    @RequestMapping(value = {"/v2/area/parent-code/{parentCode}", "/v3/area/by-parent-code/{parentCode}"}, method = RequestMethod.GET)
    @ApiOperation(value = "根据区域父编码查询区域", notes = "根据区域父编码查询区域")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "parentCode", value = "区域父编码", dataType = "String", paramType = "path", required = true)
    })
    @Capability(capabilityCode = "basicdata.area.query-by-parent-code")
    RestResponse<List<AreaDto>> queryByParentCode(@PathVariable("parentCode") String parentCode);

    /**
     * 查询区域树
     *
     * @return AreaTreeRespDto
     */
    @RequestMapping(value = {"/v2/area/tree", "/v3/area/tree"}, method = RequestMethod.GET)
    @ApiOperation(value = "查询区域树", notes = "查询区域树")
    @Capability(capabilityCode = "basicdata.area.query-for-tree")
    RestResponse<List<AreaTreeRespDto>> queryForTree();

    /**
     * 查询区域树
     *
     * @return AreaTreeRespDto
     */
    @Deprecated
    @RequestMapping(value = {"/v2/area/tree/level/{level}", "/v3/area/tree/by-level/{level}"}, method = RequestMethod.GET)
    @ApiOperation(value = "查询区域树", notes = "查询区域树")
    @Capability(capabilityCode = "basicdata.area.query-for-tree")
    RestResponse<List<AreaTreeRespDto>> queryForTree(@PathVariable("level") Integer level);

    /**
     * 查询区域树，仅支持返回省市区，不支持查询街道
     *
     * @param level 指定查询的层级深度（1 表示查询到省 2表示查询到市  3表示查询到区）
     * @return
     */
    @RequestMapping(value = {"/v3/area/tree/by-level"}, method = RequestMethod.GET)
    @ApiOperation(value = "查询区域树", notes = "查询区域树，指定查询的层级深度（1 表示查询到省 2表示查询到市  3表示查询到区）；仅支持返回省市区，最多返回区，不支持查询街道")
    @Capability(capabilityCode = "basicdata.area.query-by-level-for-tree")
    RestResponse<List<AreaTreeRespDto>> queryByLevelForTree(@RequestParam("level") Integer level);
}
