package com.dtyunxi.yundt.cube.center.data.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.WeChatAreaQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaTreeRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@Api(tags = {"基础数据中心：区域数据管理：微信区域信息查询服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-query-IWeChatAreaQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", url = "${yundt.cube.center.data.api:}")
public interface IWeChatAreaQueryApi {

    /**
     * 根据微信地址查询区域
     *
     * @param queryReqDto
     * @return
     */
    @RequestMapping(value = {"/v3/we-chat/area"}, method = RequestMethod.GET)
    @ApiOperation(value = "根据微信地址查询区域", notes = "根据微信地址查询区域")
    RestResponse<AreaDto> queryByWeChatAreaInfo(@SpringQueryMap WeChatAreaQueryReqDto queryReqDto);

    /**
     * 查询微信区域树，仅支持返回省市两级数据
     *
     * @return
     */
    @RequestMapping(value = {"/v3/we-chat/area/tree"}, method = RequestMethod.GET)
    @ApiOperation(value = "查询微信区域树，仅支持返回省市两级数据", notes = "查询微信区域树，仅支持返回省市两级数据")
    RestResponse<List<AreaTreeRespDto>> queryWeChatAreaForTree();
}
