/*
 * @(#)IAreaApi.java 1.0 2018/8/20
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.data.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.AreaGroupReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;


/**
 * 区域分组信息 API接口
 *
 * @author 云舒
 * @since 1.0.0
 */
@Api(tags = {"基础数据中心：区域数据管理：区域分组信息服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-data-api-IAreaGroupApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", url = "${yundt.cube.center.data.api:}")
public interface IAreaGroupApi {

    /**
     * 新增区域分组
     *
     * @param areaGroupReqDto 新增区域分组
     * @return Long 数据保存后的ID
     */
    @PostMapping({"/v2/area-group", "/v3/area-group"})
    @ApiOperation(value = "新增区域分组", notes = "新增区域分组")
    @Capability(capabilityCode = "basicdata.area-group.save-area-group")
    RestResponse<Long> saveAreaGroup(@Validated @RequestBody AreaGroupReqDto areaGroupReqDto);

    /**
     * 通过ID删除
     *
     * @param id
     * @return RestResponse&lt;Void&gt;
     */
    @Deprecated
    @DeleteMapping({"/v2/area-group/{id}", "/v3/area-group/{id}"})
    @ApiOperation(value = "删除区域分组", notes = "根据区域分组ID删除数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "区域分组ID", dataType = "Long", paramType = "path", required = true)

    })
    @Capability(capabilityCode = "basicdata.area-group.remove-by-id")
    RestResponse<Void> removeById(@PathVariable("id") Long id);

    /**
     * 修改区域分组
     *
     * @param areaGroupReqDto 区域分组实体
     * @return RestResponse&lt;Void&gt;
     */
    @Deprecated
    @PutMapping({"/v2/area-group/{id}", "/v3/area-group/{id}"})
    @ApiOperation(value = "修改区域分组", notes = "修改区域分组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "区域分组ID", dataType = "Long", paramType = "path", required = true)

    })
    @Capability(capabilityCode = "basicdata.area-group.modify-area-group")
    RestResponse<Void> modifyAreaGroup(@PathVariable("id") Long id, @Validated @RequestBody AreaGroupReqDto areaGroupReqDto);
}
