package com.dtyunxi.yundt.cube.center.data.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Map;

@Api(tags = {"基础数据中心：区域数据管理：OSS服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-data-api-IFileApi",
        name = "${yundt.cube.center.data.name:yundt-cube-center-data}", path = "/v1/file", url = "${yundt.cube.center.data.api:}")
public interface IFileApi {

    /**
     * 获取oss签名
     *
     * @return
     */
    @Deprecated
    @PostMapping("/upload/policy")
    @ApiOperation(value = "获取oss签名", notes = "获取oss签名")
    @Capability(capabilityCode = "basicdata.file.upload-file-policy")
    RestResponse<Map<String, String>> uploadFilePolicy();

    /**
     * 获取oss签名
     *
     * @return
     */
    @GetMapping("/upload/policy")
    @ApiOperation(value = "获取oss签名", notes = "获取oss签名")
    @Capability(capabilityCode = "basicdata.file.upload-file-policy-by-get")
    RestResponse<Map<String, String>> uploadFilePolicyByGet();

    /**
     * 上传文件
     *
     * @param file
     * @return
     */
    @PostMapping("/upload")
    @ApiOperation(value = "上传文件", notes = "上传文件")
    @Capability(capabilityCode = "basicdata.file.upload-file")
    RestResponse<Map<String, Object>> uploadFile(@RequestParam("file") MultipartFile file);

}
