package com.dtyunxi.yundt.cube.center.data.api.constants;

import org.apache.commons.lang3.StringUtils;

/**
 * 缓存键
 * @author : 萧玄
 * @Date: 10:51 2019/7/11
 */
public class RedisKeyConstants {

    public static final int ONE_MINUTE = 60;

    public static final int FIVE_MINUTE = 5 * ONE_MINUTE;

    public static final int ONE_HOUR = 60 * ONE_MINUTE;

    public static final int ONE_DAY = 24 * ONE_HOUR;

    public static final int ONE_WEEK = 7 * ONE_DAY;


    public static final int ONE_YEAR = 365 * ONE_DAY;

    public static final int HALF_ONE_HOUR = 30 * ONE_MINUTE;

    /**
     * API权限redis键
     */
    public static final String API_PERMISSION_KEY = "API_PERMISSION";

    public static final String DOMAIN_APP_KEY = "DOMAIN_APP_KEY";

    /**
     * 区域信息redis键
     */

    public static final String QUERY_BY_CODE = "queryByCode";

    public static final String QUERY_BY_PARENT_CODE = "queryByParentCode";

    public static final String QUERY_BY_LEVEL_FOR_TREE = "areaCache";

    public static final String QUERY_DICT = "dictCache";

    public static final String QUERY_DICT_BY_GROUP_AND_CODE = "queryByGroupCodeAndCode";

    public static final String QUERY_DICT_BY_GROUP = "queryByGroupCode";

    public static final String QUERY_DICT_VALUE_BY_DICT_ID = "queryDictValueListByDictId";

    public static final String NONE_VALUE = "none_value";
    /**
     * 组合成最终键，按冒号分割各参数
     * @author : 萧玄
     * @Date   : 10:55 2019/7/11
     * @param prefix
     * @param params
     * @return : java.lang.String
     */
    public static String combineKey(String prefix,Object... params){
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if(params != null){
            for(Object param:params){
                if (param != null && StringUtils.isNotEmpty(param.toString())){
                    sb.append(":").append(param);
                }
            }
        }
        return sb.toString();
    }
}
