/*
 * @(#)AreaComparisionReqDto.java 1.0 2018/9/11
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.data.api.dto;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 区域信息对照Dto实体
 *
 * @author 华生
 * @since 1.0.0
 */
@ApiModel(value = "AreaComparisionQueryReqDto ", description = "区域对照信息查询Dto")
public class AreaComparisionQueryReqDto extends BaseReqDto {

    private static final long serialVersionUID = -5324816712440464388L;

    @ApiModelProperty(value = "区域对照ID")
    private Long id;

    /**
     * 省份编码
     */
    @ApiModelProperty(value = "省份编码")
    private String provinceCode;

    /**
     * 省份编码
     */
    @ApiModelProperty(value = "城市编码")
    private String cityCode;

    /**
     * 区域编码
     */
    @ApiModelProperty(value = "区域编码")
    private String areaCode;

    /**
     * 可以是名称也可以是编码，由上层业务决定
     */
    @ApiModelProperty(value = "第三方平台编码")
    private String thirdPlanformCode;

    /**
     * 第三方省份名称
     */
    @ApiModelProperty(value = "第三方省份名称")
    private String thirdProvince;

    /**
     * 第三方城市名称
     */
    @ApiModelProperty(value = "第三方城市名称")
    private String thirdCity;

    /**
     * 第三方区域名称
     */
    @ApiModelProperty(value = "第三方区域名称")
    private String thirdArea;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createPerson;

    /**
     * 更新人
     */
    @ApiModelProperty(value = "更新人")
    private String updatePerson;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "dr")
    private Integer dr;

    /**
     * 每页页大小
     */
    @ApiModelProperty(value = "每页页大小")
    private int pageSize = 10;

    /**
     * 页码
     */
    @ApiModelProperty(value = "页码")
    private int pageNum = 1;

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getThirdPlanformCode() {
        return thirdPlanformCode;
    }

    public void setThirdPlanformCode(String thirdPlanformCode) {
        this.thirdPlanformCode = thirdPlanformCode;
    }

    public String getThirdProvince() {
        return thirdProvince;
    }

    public void setThirdProvince(String thirdProvince) {
        this.thirdProvince = thirdProvince;
    }

    public String getThirdCity() {
        return thirdCity;
    }

    public void setThirdCity(String thirdCity) {
        this.thirdCity = thirdCity;
    }

    public String getThirdArea() {
        return thirdArea;
    }

    public void setThirdArea(String thirdArea) {
        this.thirdArea = thirdArea;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreatePerson() {
        return createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public String getUpdatePerson() {
        return updatePerson;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getDr() {
        return dr;
    }

    public void setDr(Integer dr) {
        this.dr = dr;
    }
}
