/*
 * @(#)AreaDto.java 1.0 2018/8/20
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.data.api.dto;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;

/**
 * 区域信息Dto实体
 *
 * @author 华生
 * @since 1.0.0
 */
@ApiModel(value = "AreaDto ", description = "区域信息Dto")
public class AreaDto extends BaseVo {

    private static final long serialVersionUID = -3537290529178125512L;

    @ApiModelProperty(value = "区域信息ID")
    private Long id;

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码")
    @NotNull(message = "编码不能为空")
    private String code;

    /**
     * 父编码
     */
    @ApiModelProperty(value = "父编码")
    @NotNull(message = "父编码不能为空")
    private String parentCode;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    @NotNull(message = "区域名称不能为空")
    private String name;

    /**
     * 邮编
     */
    @ApiModelProperty(value = "邮编")
    private String postCode;

    /**
     * 级别
     */
    @ApiModelProperty(value = "级别")
    private Integer levelId;

    /**
     * 电话区号
     */
    @ApiModelProperty(value = "电话区号")
    private String diallingCode;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createPerson;

    /**
     * 更新人
     */
    @ApiModelProperty(value = "更新人")
    private String updatePerson;

    @ApiModelProperty(value = "dr")
    private Integer dr;

    @ApiModelProperty(value = "是否还有子区域")
    private Boolean hasChildren;

    @ApiModelProperty(value = "拓展字段")
    private String extension;

    @ApiModelProperty(value = "民政部编码，新增和编辑时无效(自动取编码前6位)")
    private String caCode;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPostCode() {
        return postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public Integer getLevelId() {
        return levelId;
    }

    public void setLevelId(Integer levelId) {
        this.levelId = levelId;
    }

    public String getDialingCode() {
        return diallingCode;
    }

    public void setDialingCode(String dialingCode) {
        this.diallingCode = dialingCode;
    }

    public String getDiallingCode() {
        return diallingCode;
    }

    public void setDiallingCode(String diallingCode) {
        this.diallingCode = diallingCode;
    }

    public String getCreatePerson() {
        return createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public String getUpdatePerson() {
        return updatePerson;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }


    public Integer getDr() {
        return dr;
    }

    public void setDr(Integer dr) {
        this.dr = dr;
    }

    public Boolean getHasChildren() {
        return hasChildren;
    }

    public void setHasChildren(Boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getCaCode() {
        return caCode;
    }

    public void setCaCode(String caCode) {
        this.caCode = caCode;
    }
}
