package com.dtyunxi.yundt.cube.center.data.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author 云舒
 * @since 2.0.0
 */
@ApiModel(value = "AreaGroupDto", description = "区域分组信息Dto")
public class AreaGroupReqDto extends BaseReqDto {

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码")
    @NotNull(message = "编码不能为空")
    private String code;

    /**
     * 父编码
     */
    @ApiModelProperty(value = "父编码")
    private String parentCode;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    @NotNull(message = "区域分组名称不能为空")
    private String name;

    /**
     * 区域编码列表
     */
    @ApiModelProperty(value = "区域编码列表")
    private List<String> areaCodes;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getAreaCodes() {
        return areaCodes;
    }

    public void setAreaCodes(List<String> areaCodes) {
        this.areaCodes = areaCodes;
    }
}
