/*
 * @(#)IAreaComparisionQueryApi.java 1.0 2018/8/20
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.data.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaComparisionDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaComparisionQueryReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 区域对照类查询API
 *
 * @author 华生
 * @since 1.0.0
 */

@Api(tags = {"基础数据中心：区域数据管理：区域信息对照查询服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-data-api-query-IAreaComparisionQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", url = "${yundt.cube.center.data.api:}")
public interface IAreaComparisionQueryApi {

    /**
     * 根据区域编码和平台信息查询第三方平台信息
     *
     * @param areaCode 区域编码
     * @param thirdPlanformCode 第三方平台编码
     * @return AreaComparisionDto
     */
    @RequestMapping(value = {"v2/area-comparision/{areaCode}/third/{thirdPlanformCode}"}, method = RequestMethod.GET)
    @ApiOperation(value = "根据区域编码和平台信息查询第三方平台信息", notes = "根据区域编码和平台信息查询第三方平台信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "区域编码", dataType = "String", paramType = "path", required = true),
            @ApiImplicitParam(name = "thirdPlanformCode", value = "第三方平台编码", dataType = "String", paramType = "path", required = true)
    })
    @Capability(capabilityCode = "basicdata.area-comparision.query-area-comparision")
    RestResponse<List<AreaComparisionDto>> queryAreaComparision(@PathVariable("areaCode") String areaCode,
                                                                @PathVariable("thirdPlanformCode") String thirdPlanformCode);

    /**
     * 根据区域编码和平台信息查询第三方平台信息
     *
     * @param areaCode 区域编码
     * @param thirdPlanformCode 第三方平台编码
     * @return AreaComparisionDto
     */
    @RequestMapping(value = {"v3/area-comparision/by-area-code"}, method = RequestMethod.GET)
    @ApiOperation(value = "v3根据区域编码和平台信息查询第三方平台信息", notes = "根据区域编码和平台信息查询第三方平台信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "区域编码", dataType = "String", paramType = "path", required = true),
            @ApiImplicitParam(name = "thirdPlanformCode", value = "第三方平台编码", dataType = "String", paramType = "path", required = true)
    })
    @Capability(capabilityCode = "basicdata.area-comparision.query-area-comparision-v3")
    RestResponse<List<AreaComparisionDto>> queryAreaComparisionV3(@RequestParam("areaCode") String areaCode,
                                                                @RequestParam("thirdPlanformCode") String thirdPlanformCode);


    /**
     * 根据第三方区域名称和平台信息查询第三方平台信息

     * @param thirdArea 第三方区域名称
     * @param thirdPlanformCode 第三方平台编码
     * @return AreaComparisionDto
     */
    @RequestMapping(value = {"v2/area-comparision/third/{thirdArea}/{thirdPlanformCode}"}, method = RequestMethod.GET)
    @ApiOperation(value = "根据第三方区域名称和平台信息查询第三方平台信息", notes = "根据第三方区域名称和平台信息查询第三方平台信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "thirdArea", value = "第三方区域名称", dataType = "String", paramType = "path", required = true),
            @ApiImplicitParam(name = "thirdPlanformCode", value = "第三方平台编码", dataType = "String", paramType = "path", required = true)
    })
    @Capability(capabilityCode = "basicdata.area-comparision.query-area-comparision-by-third-area")
    RestResponse<List<AreaComparisionDto>> queryAreaComparisionByThirdArea(
            @PathVariable("thirdArea") String thirdArea,
            @PathVariable("thirdPlanformCode") String thirdPlanformCode);


    /**
     * 根据第三方区域名称和平台信息查询第三方平台信息

     * @param thirdArea 第三方区域名称
     * @param thirdPlanformCode 第三方平台编码
     * @return AreaComparisionDto
     */
    @RequestMapping(value = {"v3/area-comparision/by-third-area-code"}, method = RequestMethod.GET)
    @ApiOperation(value = "v3根据第三方区域名称和平台信息查询第三方平台信息", notes = "根据第三方区域名称和平台信息查询第三方平台信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "thirdArea", value = "第三方区域名称", dataType = "String", paramType = "path", required = true),
            @ApiImplicitParam(name = "thirdPlanformCode", value = "第三方平台编码", dataType = "String", paramType = "path", required = true)
    })
    @Capability(capabilityCode = "basicdata.area-comparision.query-area-comparision-by-third-area-v3")
    RestResponse<List<AreaComparisionDto>> queryAreaComparisionByThirdAreaV3(
            @RequestParam("thirdArea") String thirdArea,
            @RequestParam("thirdPlanformCode") String thirdPlanformCode);


    /**
     * 分页查询列表
     *
     * @param areaComparisionQueryReqDto 区域对照查询请求Dto
     * @return PageInfo
     */
    @RequestMapping(value = {"v2/area-comparision/list", "/v3/area-comparision"}, method = RequestMethod.GET)
    @ApiOperation(value = "分页查询区域对照信息", notes = "分页查询区域对照信息")
    @Capability(capabilityCode = "basicdata.area-comparision.query-by-page")
    RestResponse<PageInfo<AreaComparisionDto>> queryByPage(
            AreaComparisionQueryReqDto areaComparisionQueryReqDto);
}
