/*
 * @(#)IAreaQueryApi.java 1.0 2018/8/20
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.data.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupDetailRespDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupRespDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupTreeRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 区域分组信息查询API
 *
 * @author 云舒
 * @since 1.0.0
 */

@Api(tags = {"基础数据中心：区域数据管理：区域分组信息查询服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-data-api-query-IAreaGroupQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", url = "${yundt.cube.center.data.api:}")
public interface IAreaGroupQueryApi {

    /**
     * 通过ID查找区域分组
     *
     * @param id 区域分组Id
     * @return AreaGroupDetailRespDto
     */
    @Deprecated
    @GetMapping({"/v2/area-group/{id}", "/v3/area-group/{id}"})
    @ApiOperation(value = "根据区域分组ID查询区域分组", notes = "根据区域分组ID查询区域分组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "区域分组ID", dataType = "Long", paramType = "path", required = true)
    })
    @Capability(capabilityCode = "basicdata.area-group.query-by-key")
    RestResponse<AreaGroupDetailRespDto> queryByKey(@PathVariable("id") Long id);


    /**
     * 分页查询分组
     *
     * @param filter
     * @return PageInfo
     */
    @GetMapping({"/v2/area-group/page", "/v3/area-group"})
    @ApiOperation(value = "分页查询区域分组", notes = "分页查询区域分组")
    @Capability(capabilityCode = "basicdata.area-group.query-by-page")
    RestResponse<PageInfo<AreaGroupRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                         @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                         @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 通过编码查找区域分组
     *
     * @param code 区域分组编码
     * @return AreaGroupDetailRespDto
     */
    @GetMapping({"/v2/area-group/code/{code}", "/v3/area-group/{code}"})
    @ApiOperation(value = "根据区域分组编码查询区域分组", notes = "根据区域分组编码查询区域分组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "区域分组编码", dataType = "String", paramType = "path", required = true)
    })
    @Capability(capabilityCode = "basicdata.area-group.query-by-code")
    RestResponse<AreaGroupDetailRespDto> queryByCode(@PathVariable("code") String code);

    /**
     * 通过父编码查找区域分组
     *
     * @param parentCode 父编码
     * @return AreaGroupRespDtoList
     */
    @GetMapping({"/v2/area-group/parent-code/{parentCode}", "/v3/area-group/by-parent-code/{parentCode}"})
    @ApiOperation(value = "根据区域分组父编码查询区域分组", notes = "根据区域分组父编码查询区域分组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "parentCode", value = "区域分组父编码", dataType = "String", paramType = "path", required = true)
    })
    @Capability(capabilityCode = "basicdata.area-group.query-by-parent-code")
    RestResponse<List<AreaGroupRespDto>> queryByParentCode(@PathVariable("parentCode") String parentCode);

    /**
     * 通过区域编码查找区域分组
     *
     * @param areaCodes 区域编码
     * @return AreaGroupDetailRespDto
     */
    @GetMapping({"/v2/area-group/area-code/{areaCodes}"})
    @ApiOperation(value = "根据区域分组编码查询区域分组", notes = "根据区域分组编码查询区域分组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCodes", value = "区域编码数组'',''", dataType = "String", paramType = "path", required = true)
    })
    @Capability(capabilityCode = "basicdata.area-group.query-by-area-codes")
    RestResponse<List<AreaGroupRespDto>> queryByAreaCodes(@PathVariable("areaCodes") String[] areaCodes);

    /**
     * 通过区域编码查找区域分组
     *
     * @param areaCodes 区域编码
     * @return AreaGroupDetailRespDto
     */
    @GetMapping({"/v3/area-group/by-area-codes"})
    @ApiOperation(value = "v3根据区域分组编码查询区域分组", notes = "根据区域分组编码查询区域分组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCodes", value = "区域编码数组'',''", dataType = "String", paramType = "query", required = true)
    })
    @Capability(capabilityCode = "basicdata.area-group.query-by-area-codes-v3")
    RestResponse<List<AreaGroupRespDto>> queryByAreaCodesV3(@RequestParam("areaCodes") String[] areaCodes);

    /**
     * 查询区域分组树
     *
     * @return AreaGroupDetailRespDto
     */
    @GetMapping({"/v2/area-group/tree", "/v3/area-group/tree"})
    @ApiOperation(value = "查询区域分组树", notes = "查询区域分组树")
    @Capability(capabilityCode = "basicdata.area-group.query-for-tree")
    RestResponse<List<AreaGroupTreeRespDto>> queryForTree();

    /**
     * 根据层级查询
     *
     * @return AreaGroupDetailRespDto
     */
    @GetMapping({"/v2/area-group/list/level/{level}", "/v3/area-group/by-level/{level}"})
    @ApiOperation(value = "按层级查询区域分组", notes = "按层级查询区域分组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "level", value = "查询层级", dataType = "Long", paramType = "path", required = true)
    })
    @Capability(capabilityCode = "basicdata.area-group.query-by-level")
    RestResponse<List<AreaGroupRespDto>> queryByLevel(@PathVariable("level") Integer level);

}
