/*
 * @(#)IDictQueryApi.java1.0 2018年7月17日
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.data.api.query;


import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Dict  字典数据查询服务API接口
 *
 * @author 古奇
 * @since 1.0.0
 */
@Api(tags = {"基础数据中心：区域数据管理：字典项数据查询服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-query-IDictQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", url = "${yundt.cube.center.data.api:}")
public interface IDictQueryApi {

    /**
     * 根据分组和code查询字典数据
     *
     * @param tenantId  租户Id
     * @param groupCode 分组
     * @param code      Key
     * @return 字典数据
     */
    @RequestMapping(value = {"/v2/dict/{tenantId}/{groupCode}/{code}"}, method = RequestMethod.GET)
    @ApiOperation(value = "查询字典", notes = "根据分组和code查询字典数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tenantId", value = "租户id", dataType = "long", paramType = "path", required = true),
            @ApiImplicitParam(name = "groupCode", value = "分组", dataType = "string", paramType = "path", required = true),
            @ApiImplicitParam(name = "code", value = "code", dataType = "string", paramType = "path", required = true),
    })
    @Capability(capabilityCode = "basicdata.dict.query-by-group-code-and-code")
    RestResponse<DictDto> queryByGroupCodeAndCode(@PathVariable("tenantId") Long tenantId,
                                                  @PathVariable("groupCode") String groupCode,
                                                  @PathVariable("code") String code);

    /**
     * 根据分组和code查询字典数据
     *
     * @param tenantId  租户Id
     * @param groupCode 分组
     * @param code      Key
     * @return 字典数据
     */
    @RequestMapping(value = {"/v3/dict-entry/by-group-code/{groupCode}/by-code/{code}"}, method = RequestMethod.GET)
    @ApiOperation(value = "v3查询字典", notes = "根据分组和code查询字典数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tenantId", value = "租户id", dataType = "long", paramType = "query", required = true),
            @ApiImplicitParam(name = "groupCode", value = "分组", dataType = "string", paramType = "path", required = true),
            @ApiImplicitParam(name = "code", value = "code", dataType = "string", paramType = "path", required = true),
    })
    @Capability(capabilityCode = "basicdata.dict.query-by-group-code-and-code-v3")
    RestResponse<DictDto> queryByGroupCodeAndCodeV3(@RequestParam("tenantId") Long tenantId,
                                                    @PathVariable("groupCode") String groupCode,
                                                    @PathVariable("code") String code);

    /**
     * 查询指定分组下的字典集合
     *
     * @param tenantId, 租户Id
     * @param groupCode 枚举分组
     * @return 字典集合
     */
    @RequestMapping(value = {"/v2/dict/{tenantId}/{groupCode}/list"}, method = RequestMethod.GET)
    @ApiOperation(value = "查询指定分组下的字典集合", notes = "查询指定分组下的字典集合,groupCode:分组。")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tenantId", value = "租户id", dataType = "long", paramType = "path", required = true),
            @ApiImplicitParam(name = "groupCode", value = "分组", dataType = "string", paramType = "path", required = true),
    })
    @Capability(capabilityCode = "basicdata.dict.query-by-group-code")
    RestResponse<List<DictDto>> queryByGroupCode(@PathVariable("tenantId") Long tenantId,
                                                 @PathVariable("groupCode") String groupCode);

    /**
     * 查询指定分组下的字典集合
     *
     * @param tenantId, 租户Id
     * @param groupCode 枚举分组
     * @return 字典集合
     */
    @RequestMapping(value = {"/v3/dict-entry/by-group-code/{groupCode}"}, method = RequestMethod.GET)
    @ApiOperation(value = "查询指定分组下的字典集合", notes = "查询指定分组下的字典集合,groupCode:分组。")
    @Capability(capabilityCode = "basicdata.dict.query-by-group-code")
    RestResponse<List<DictDto>> queryByGroupCodeV3(@RequestParam(value = "tenantId", required = false) Long tenantId,
                                                   @PathVariable("groupCode") String groupCode);

    /**
     * 根据查询条件查询枚举数据
     *
     * @param filter   查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 分页数据
     */
    @GetMapping({"/v2/dict/page", "/v3/dict-entry"})
    @ApiOperation(value = "根据查询条件查询枚举数据", notes = "filter=DictDto")
    @Capability(capabilityCode = "basicdata.dict.query-by-page")
    RestResponse<PageInfo<DictDto>> queryByPage(@RequestParam("filter") String filter,
                                                @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
