/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.biz.apiimpl.query;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaTreeRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.cube.center.data.biz.service.IAreaService;
import com.dtyunxi.yundt.cube.center.data.dao.eo.AreaEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;

@Service(value="areaQueryApi")
@Validated
public class AreaQueryApiImpl
implements IAreaQueryApi {
    @Autowired
    IAreaService iAreaService;

    public RestResponse<AreaDto> queryAreaByKey(Long areaId) {
        AreaEo areaEo = this.iAreaService.queryAreaByKey(areaId);
        AreaDto areaDto = new AreaDto();
        DtoHelper.eo2Dto((BaseEo)areaEo, (BaseVo)areaDto);
        return new RestResponse((Object)areaDto);
    }

    public RestResponse<PageInfo<AreaDto>> queryByPage(AreaQueryReqDto areaQueryReqDto) {
        AreaEo areaEo = new AreaEo();
        DtoHelper.dto2Eo((BaseVo)areaQueryReqDto, (BaseEo)areaEo);
        Integer pageNum = areaQueryReqDto.getPageNum();
        Integer pageSize = areaQueryReqDto.getPageSize();
        PageInfo<AreaEo> pageInfoEo = this.iAreaService.queryByPage(areaEo, pageNum, pageSize);
        ArrayList dtos = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)pageInfoEo.getList())) {
            DtoHelper.eoList2DtoList((Collection)pageInfoEo.getList(), dtos, AreaDto.class);
        }
        pageInfoEo.setList(dtos);
        return new RestResponse(pageInfoEo);
    }

    public RestResponse<AreaDto> queryByCode(String code) {
        AreaEo areaEo = this.iAreaService.queryByCode(code);
        AreaDto areaDto = new AreaDto();
        DtoHelper.eo2Dto((BaseEo)areaEo, (BaseVo)areaDto);
        return new RestResponse((Object)areaDto);
    }

    public RestResponse<List<AreaDto>> queryByParentCode(String parentCode) {
        return new RestResponse(this.iAreaService.queryByParentCode(parentCode));
    }

    public RestResponse<List<AreaTreeRespDto>> queryForTree() {
        return new RestResponse(this.iAreaService.queryForTree());
    }

    public RestResponse<List<AreaTreeRespDto>> queryForTree(Integer level) {
        return new RestResponse(this.iAreaService.queryForTree(level));
    }

    public RestResponse<List<AreaTreeRespDto>> queryByLevelForTree(Integer level) {
        return new RestResponse(this.iAreaService.queryByLevelForTree(level));
    }
}

