/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.biz.apiimpl.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.exception.CenterDataExceptionCode;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.data.biz.service.IDictService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;

@Service(value="dictQueryApi")
@Validated
public class DictQueryApiImpl
implements IDictQueryApi {
    @Autowired
    private IDictService dictService;
    @Resource
    private IContext context;

    public RestResponse<DictDto> queryByGroupCodeAndCode(Long tenantId, String groupCode, String code) {
        DictDto dictDto = this.dictService.queryByGroupCodeAndCode(tenantId, groupCode, code);
        if (dictDto == null) {
            RestResponse restResponse = new RestResponse();
            restResponse.setResultCode(CenterDataExceptionCode.DICT_NOT_EXISTS.getCode());
            restResponse.setResultMsg(CenterDataExceptionCode.DICT_NOT_EXISTS.getMsg());
            return restResponse;
        }
        return new RestResponse((Object)dictDto);
    }

    public RestResponse<DictDto> queryByGroupCodeAndCodeV3(Long tenantId, String groupCode, String code) {
        return this.queryByGroupCodeAndCode(tenantId, groupCode, code);
    }

    public RestResponse<List<DictDto>> queryByGroupCode(Long tenantId, String groupCode) {
        List<DictDto> dictDtoList = this.dictService.queryByGroupCode(tenantId, groupCode);
        return new RestResponse(dictDtoList);
    }

    public RestResponse<List<DictDto>> queryByGroupCodeV3(Long tenantId, String groupCode) {
        if (tenantId == null) {
            tenantId = this.context.tenantId();
        }
        List<DictDto> dictDtoList = this.dictService.queryByGroupCode(tenantId, groupCode);
        return new RestResponse(dictDtoList);
    }

    public RestResponse<PageInfo<DictDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.dictService.queryByPage(filter, pageNum, pageSize));
    }
}

